  /*
* ===========================================================================
* Crouser Agnostic Platform JavaScript Library - 2011-2023
* v3.21 - Written by Rex Edward Crouser II
*
* All material is copyright 2018 Rex Edward Crouser II. No material may be
* reproduced without the express written consent of the author.
* ===========================================================================
* Search for @REC for ALL yearly changes!!!!!
*/

// var platform = 'pc';
// var platform = 'mac';
// var platform = 'linux';
// var platform = 'mobile';
// var platform = 'web';
// var guide    = 'offset';
// var guide    = 'digital';
// var guide    = 'wide';

var guide     = 'offset';
var platform  = 'mac';
var version   = '2.1.6';
var guideyear = '2026';

var currentpos, timer;
function writeSessionCookie(cookieName, cookieValue)  { if(platform == 'pc') { window.external.SetGlobalVariable(cookieName, cookieValue, true); }else { if (testSessionCookie()) { document.cookie = escape(cookieName) + "=" + escape(cookieValue) + "; path=/"; return true; } else return false; } }
function getCookieValue(cookieName)                   { if(platform == 'pc') { return window.external.GetGlobalVariable(ccokieName,""); }else { var exp = new RegExp (escape(cookieName) + "=([^;]+)"); if (exp.test (document.cookie + ";")) { exp.exec (document.cookie + ";"); return unescape(RegExp.$1); } else return false; } }
function deleteCookie(cookieName)                     { if(getCookieValue (cookieName)) writePersistentCookie (cookieName,"Pending delete","years", -1); return true; }
function alltrim(stringToTrim)                        { return stringToTrim.replace(/^\s+|\s+$/g,""); }
function killerrors()                                 { return true; }
function initialize()                                 { timer=setInterval("scrollwindow()",10); }
function sc()                                         { clearInterval(timer); }
function scrollwindow()                               { currentpos=document.body.scrollTop; window.scroll(0,++currentpos); if (currentpos != document.body.scrollTop) sc(); }
function copyText(divID)                              { var success = false; var copyDivText = document.getElementById(divID).innerText; if (window.clipboardData) { var returnVal   = window.clipboardData.setData('Text',copyDivText); } else { var forExecElement = createElementForExecCommand(copyDivText); selectContent(forExecElement); var supported = true; try { if (window.netscape && netscape.security) { netscape.security.PrivilegeManager.enablePrivilege ("UniversalXPConnect"); } success = document.execCommand ("copy", false, null); } catch (e) { success = false; } document.body.removeChild (forExecElement); } }
function createElementForExecCommand(textToClipboard) { var forExecElement = document.createElement("div"); forExecElement.style.position = "absolute"; forExecElement.style.left = "-10000px"; forExecElement.style.top = "-10000px"; forExecElement.textContent = textToClipboard; document.body.appendChild (forExecElement); forExecElement.contentEditable = true; return forExecElement; }
function selectContent(element)                       { var rangeToSelect = document.createRange (); rangeToSelect.selectNodeContents (element); var selection = window.getSelection (); selection.removeAllRanges (); selection.addRange (rangeToSelect); }
function checkforUpdates()                            { top.document.location.href = 'http://crouser.com/updates/' + guide + '/' + version + '/' + platform + '.html'; return true; }
function strtoupper (str)                             { return (str + '').toUpperCase(); }

// window.onerror = killerrors;
document.onmousedown=sc;
document.ondblclick=initialize;

// =- function: keyParser() for Serial Keys ----------------------------------------------=
function keyParser(key)
{
        var newKey = strtoupper(alltrim(key));                // Convert all incoming keys to uppercase

        if (newKey.length < 20) { for (i = 0; i < 30; i++) { newKey = newKey + "X"; } }                                             // Minimum length for a key is 20, otherwise fill it up with "X"s
        if (newKey.substr(5,1) == "-" && newKey.substr(11,1) == "-" && newKey.substr(17,1) == "-") { return newKey.substr(0,23); }  // If the key is correct simply return the parsed key

        if (newKey.substr(5,1)  != "-") { newKey = newKey.substr(0,5)  + "-" + newKey.substr(5,newKey.length);  }                   // Add first dash if required
        if (newKey.substr(11,1) != "-") { newKey = newKey.substr(0,11) + "-" + newKey.substr(11,newKey.length); }                   // Add second dash if required
        if (newKey.substr(17,1) != "-") { newKey = newKey.substr(0,17) + "-" + newKey.substr(17,newKey.length); }                   // Add third dash if required

return newKey.substr(0,23);                  // Return the correctly parsed key
}

// =- function: tabsStartUp() for Offset Tabs --------------------------------------------=
function tabsStartUp() {
//      alert("function tabsStartUp()");
        var level = "Y";

        if(platform == 'pc' ) {  var level = "Y"; }
//@REC
//                if (window.external.GetGlobalVariable("pc-defaultPrice","2") == "1") { var level = "X"; }else
//                if (window.external.GetGlobalVariable("pc-defaultPrice","2") == "2") { var level = "Y"; }else
//                if (window.external.GetGlobalVariable("pc-defaultPrice","2") == "3") { var level = "Z"; }else { var level = "Y"; }
//                }
        if(guide == 'offset' && platform == 'mac' ) {
                if (getCookieValue("offset-defaultPrice") == 1) { var level = "X"; }
                if (getCookieValue("offset-defaultPrice") == 2) { var level = "Y"; }
                if (getCookieValue("offset-defaultPrice") == 3) { var level = "Z"; }
                }
        if(guide == 'digital' && platform == 'mac'  ) {
                if (getCookieValue("digital-defaultPrice") == 1) { var level = "X"; }
                if (getCookieValue("digital-defaultPrice") == 2) { var level = "Y"; }
                if (getCookieValue("digital-defaultPrice") == 3) { var level = "Z"; }
                }
        parent.rtop.location.href          = "tabs-"+level+".html";
}

// =- function: contentStartUp() for Content Frame ------------------------------------------=
function contentStartUp() {
//      alert("function contentStartUp()");
        var level = "Y";
        if(platform == 'pc' ) { var defaultCategory = window.external.GetGlobalVariable("pc-defaultCategory","1"); } else { defaultCategory = 1; }

        if(platform == 'pc' ) {
                if (window.external.GetGlobalVariable("pc-defaultPrice","2") == "1") { var level = "X"; var base = 0;  }else
                if (window.external.GetGlobalVariable("pc-defaultPrice","2") == "2") { var level = "Y"; var base = 1;  }else
                if (window.external.GetGlobalVariable("pc-defaultPrice","2") == "3") { var level = "Z"; var base = 2;  }else { var level = "Y"; base = 1; }
                }
        if(guide == 'offset' && platform == 'mac' ) {
                if (getCookieValue("offset-defaultPrice") == 1) { var level = "X"; }
                if (getCookieValue("offset-defaultPrice") == 2) { var level = "Y"; }
                if (getCookieValue("offset-defaultPrice") == 3) { var level = "Z"; }
                }
        if(guide == 'digital' && platform == 'mac'  ) {
                if (getCookieValue("digital-defaultPrice") == 1) { var level = "X"; }
                if (getCookieValue("digital-defaultPrice") == 2) { var level = "Y"; }
                if (getCookieValue("digital-defaultPrice") == 3) { var level = "Z"; }
                }
        if(guide == 'offset' ) {
                if(defaultCategory == 1)  { var category = "doc"; var section = 0;    gotodoc(0); }
                if(defaultCategory == 2)  { var category = "02";  var section = 3;    gotopage((386*base)+section); }
                if(defaultCategory == 3)  { var category = "03";  var section = 47;   gotopage((386*base)+section); }
                if(defaultCategory == 4)  { var category = "04";  var section = 69;   gotopage((386*base)+section); }
                if(defaultCategory == 5)  { var category = "05";  var section = 89;   gotopage((386*base)+section); }
                if(defaultCategory == 6)  { var category = "06";  var section = 123;  gotopage((386*base)+section); }
                if(defaultCategory == 7)  { var category = "07";  var section = 155;  gotopage((386*base)+section); }
                if(defaultCategory == 8)  { var category = "08";  var section = 223;  gotopage((386*base)+section); }
                if(defaultCategory == 9)  { var category = "09";  var section = 243;  gotopage((386*base)+section); }
                if(defaultCategory == 10) { var category = "10";  var section = 261;  gotopage((386*base)+section); }
                if(defaultCategory == 11) { var category = "11";  var section = 331;  gotopage((386*base)+section); }
                if(defaultCategory == 12) { var category = "12";  var section = 362;  gotopage((386*base)+section); }
                }
        if(guide == 'digital' ) {
                if(defaultCategory == 1)  { var category = "doc"; var section = 0;    gotodoc(0); }
                if(defaultCategory == 2)  { var category = "01";  var section = 1;    gotopage((4400*base)+section); }
                if(defaultCategory == 3)  { var category = "02";  var section = 501;  gotopage((4400*base)+section); }
                if(defaultCategory == 4)  { var category = "03";  var section = 2001; gotopage((4400*base)+section); }
                if(defaultCategory == 5)  { var category = "04";  var section = 1001; gotopage((4400*base)+section); }
                if(defaultCategory == 6)  { var category = "05";  var section = 1501; gotopage((4400*base)+section); }
                if(defaultCategory == 7)  { var category = "06";  var section = 3201; gotopage((4400*base)+section); }
                if(defaultCategory == 8)  { var category = "07";  var section = 100;  gotomisc(100*base);            }
                if(defaultCategory == 9)  { var category = "08";  var section = 362;  gotobind((386*base)+section);  }
                if(defaultCategory == 0)  { var category = "09";  var section = 101;  gotoenv((150*base)+section);  }
                }
//        if(category == "doc") { parent.ltop.location.href = "nav-doc.html"; } else { if(platform == 'digital') { parent.ltop.location.href = "nav-"+category+"-"+level+".html"; } else { if(guide == 'offset') { parent.ltop.location.href = "nav-"+level+category+".html"; } } }
}
// =- function: startup() for Offset Navigation --------------------------------------=
function navStartUp () {
//      alert("function navStartUp()");
        var defaultPrice    = 2;
        var defaultCategory = 1;
        var defaultUpdates  = 1;

        if(platform == 'pc' ) {
                defaultPrice    = window.external.GetGlobalVariable("pc-defaultPrice","2");
                defaultCategory = window.external.GetGlobalVariable("pc-defaultCategory","1");
                defaultUpdates  = 0;
                if(defaultPrice == "1") { var level = "X"; var base = 0; } else
                if(defaultPrice == "2") { var level = "Y"; var base = 1; } else
                if(defaultPrice == "3") { var level = "Z"; var base = 2; } else { defaultPrice = "2"; defaultCategory = "1"; defaultUpdates = "0"; var level = "Y"; }
        }
        if(guide == 'offset' && platform == 'mac' ) {
                defaultPrice    = getCookieValue("offset-defaultPrice");
                defaultCategory = getCookieValue("offset-defaultCategory");
                defaultUpdates  = 0;
                if(defaultPrice == 1) { var level = "X"; var base = 0; } else
                if(defaultPrice == 2) { var level = "Y"; var base = 1; } else
                if(defaultPrice == 3) { var level = "Z"; var base = 2; }
        }
        if(guide == 'digital' && platform == 'mac'  ) {
                defaultPrice    = getCookieValue("digital-defaultPrice");
                defaultCategory = getCookieValue("digital-defaultCategory");
                defaultUpdates  = 0;
                if(defaultPrice == 1) { var level = "X"; var base = 0; } else
                if(defaultPrice == 2) { var level = "Y"; var base = 1; } else
                if(defaultPrice == 3) { var level = "Z"; var base = 2; }
        }
        if(guide == 'offset' ) {
                if(defaultCategory == 1)  { var category = "doc"; var section = 0;    }
                if(defaultCategory == 2)  { var category = "02";  var section = 3;    }
                if(defaultCategory == 3)  { var category = "03";  var section = 47;   }
                if(defaultCategory == 4)  { var category = "04";  var section = 69;   }
                if(defaultCategory == 5)  { var category = "05";  var section = 89;   }
                if(defaultCategory == 6)  { var category = "06";  var section = 123;  }
                if(defaultCategory == 7)  { var category = "07";  var section = 155;  }
                if(defaultCategory == 8)  { var category = "08";  var section = 223;  }
                if(defaultCategory == 9)  { var category = "09";  var section = 243;  }
                if(defaultCategory == 10) { var category = "10";  var section = 261;  }
                if(defaultCategory == 11) { var category = "11";  var section = 331;  }
                if(defaultCategory == 12) { var category = "12";  var section = 362;  }
                }
        if(guide == 'digital' ) {
                if(defaultCategory == 1)  { var category = "doc"; var section = 0;    }
                if(defaultCategory == 2)  { var category = "01";  var section = 1;    }
                if(defaultCategory == 3)  { var category = "02";  var section = 501;  }
                if(defaultCategory == 4)  { var category = "03";  var section = 2001; }
                if(defaultCategory == 5)  { var category = "04";  var section = 1001; }
                if(defaultCategory == 6)  { var category = "05";  var section = 1501; }
                if(defaultCategory == 7)  { var category = "06";  var section = 3201; }
                if(defaultCategory == 8)  { var category = "07";  var section = 100;  }
                if(defaultCategory == 9)  { var category = "08";  var section = 362;  }
                if(defaultCategory == 0)  { var category = "09";  var section = 101;  }
                }
        if(category == "doc") { parent.ltop.location.href = "nav-doc.html"; } else { if(guide == 'digital') { parent.ltop.location.href = "nav-"+category+"-"+level+".html"; } else { if(guide == 'offset') { parent.ltop.location.href = "nav-"+level+category+".html"; } } }
}


// =- function: showRow ------------------------------------------------------------=
function showRow(x,y) {
        i = 0;
        while(i<x) { i++; q = "000" + i; z = 'bar-row-' + q.substring(q.length-3,q.length); document.getElementById(z).style.display = "none"; }
        q = "000" + y;
        z = 'bar-row-' + q.substring(q.length-3,q.length);
        document.getElementById(z).style.display = "block";
}

// =- function: showColumn ---------------------------------------------------------=
function showColumn(x,y) {
        i = 0;
        while(i<x) { i++; q = "000" + i; z = 'bar-column-' + q.substring(q.length-3,q.length); document.getElementById(z).style.display = "none"; }
        q = "000" + y;
        z = 'bar-column-' + q.substring(q.length-3,q.length);
        document.getElementById(z).style.display = "block";
}

// =- function: gotodoc() ----------------------------------------------------------=
function gotodoc(newPage) {
        currentPage = parseInt(newPage);

	var strnewpage = new String("doc-");
	var szPageNum = new String(newPage);
        var szPageNumLen = 3 - szPageNum.length;
        for (i = 0; i < szPageNumLen; i++)
                strnewpage += "0";
		strnewpage = strnewpage + szPageNum + ".htm";
		parent.contents.location.href = strnewpage;
}

// =- function: Page Jump ----------------------------------------------------------=
function gotopage(newPage) {
        currentPage = parseInt(newPage);
	var strnewpage = new String("pg_");
	var szPageNum = new String(newPage);
        var szPageNumLen = 5 - szPageNum.length;
        for (i = 0; i < szPageNumLen; i++)
                strnewpage += "0";
		strnewpage = strnewpage + szPageNum + ".htm";
                if(typeof parent.contents.location == "undefined" || typeof parent.contents.location == "null") { return true; } else { parent.contents.location.href = strnewpage; }
}

// =- function: Bindery Jump -------------------------------------------------------=
function gotobind(newPage) {
        currentPage = parseInt(newPage);
        var strnewpage = new String("bind_");
        var szPageNum = new String(newPage);
        var szPageNumLen = 4 - szPageNum.length;
        for (i = 0; i < szPageNumLen; i++)
                strnewpage += "0";
                strnewpage = strnewpage + szPageNum + ".htm";
                parent.contents.location.href = strnewpage;
}

// =- function: Miscellaneous Jump -------------------------------------------------=
function gotomisc(newPage) {
        currentPage = parseInt(newPage);
	var strnewpage = new String("misc-");
	var szPageNum = new String(newPage);
        var szPageNumLen = 3 - szPageNum.length;
        for (i = 0; i < szPageNumLen; i++)
                strnewpage += "0";
		strnewpage = strnewpage + szPageNum + ".htm";
		parent.contents.location.href = strnewpage;
}

// =- function: Digital Envelopes Jump -------------------------------------------------=
function gotoenv(newPage) {
	var strnewpage = new String("env-");
	var szPageNum  = new String(newPage);

        strnewpage = strnewpage + szPageNum + ".html";
        parent.contents.location.href = strnewpage;
}

// =- Function: Bindery Page Change ------------------------------------------------=
function bindChange(levelObj, paperObj) {

        var newLevel = levelObj.options[levelObj.selectedIndex].value;
        var newPaper = paperObj.options[paperObj.selectedIndex].value;

        if(newLevel==0){ parent.rtop.location.href = "tabs-X.html"; }
        if(newLevel==1){ parent.rtop.location.href = "tabs-Y.html"; }
        if(newLevel==2){ parent.rtop.location.href = "tabs-Z.html"; }
       	if(guide == 'digital') { gotobind((parseInt(newLevel)*386)+(parseInt(newPaper)+361)); }
       	if(guide == 'offset')  { gotopage((parseInt(newLevel)*386)+(parseInt(newPaper)+361)); }
}
// =- Function: Bindery Page Change ------------------------------------------------=
function bindLevelChange(levelObj, paperObj) {

        var newLevel = levelObj.options[levelObj.selectedIndex].value;
        var newPaper = paperObj.options[paperObj.selectedIndex].value;

        if(newLevel==0){ parent.rtop.location.href = "tabs-X.html"; }
        if(newLevel==1){ parent.rtop.location.href = "tabs-Y.html"; }
        if(newLevel==2){ parent.rtop.location.href = "tabs-Z.html"; }
       	if(guide == 'digital') { gotobind((parseInt(newLevel)*386)+(parseInt(newPaper)+361)); }
       	if(guide == 'offset')  { gotopage((parseInt(newLevel)*386)+(parseInt(newPaper)+361)); }
}
// =- Function: Prepress Page Change -----------------------------------------------=
function pressChange(levelObj, paperObj) {

        var newLevel = levelObj.options[levelObj.selectedIndex].value;
        var newPaper = paperObj.options[paperObj.selectedIndex].value;

        if(newLevel==0){ parent.rtop.location.href = "tabs-X.html"; }
        if(newLevel==1){ parent.rtop.location.href = "tabs-Y.html"; }
        if(newLevel==2){ parent.rtop.location.href = "tabs-Z.html"; }
       	if(guide == 'digital') { gotobind((parseInt(newLevel)*386)+(parseInt(newPaper)+361)); }
       	if(guide == 'offset')  { gotopage((parseInt(newLevel)*386)+(parseInt(newPaper)+330)); }
}
// =- Function: Bindery Page Change ------------------------------------------------=
function pressLevelChange(levelObj, paperObj) {

        var newLevel = levelObj.options[levelObj.selectedIndex].value;
        var newPaper = paperObj.options[paperObj.selectedIndex].value;

        if(newLevel==0){ parent.rtop.location.href = "tabs-X.html"; }
        if(newLevel==1){ parent.rtop.location.href = "tabs-Y.html"; }
        if(newLevel==2){ parent.rtop.location.href = "tabs-Z.html"; }
       	if(guide == 'digital') { gotobind((parseInt(newLevel)*386)+(parseInt(newPaper)+361)); }
       	if(guide == 'offset')  { gotopage((parseInt(newLevel)*386)+(parseInt(newPaper)+330)); }
}
// =- Function: Miscellaneous Page Change ------------------------------------------=
function miscChange(levelObj, paperObj) {

        var newLevel = levelObj.options[levelObj.selectedIndex].value;
        var newPaper = paperObj.options[paperObj.selectedIndex].value;

        if(newLevel==0){ parent.rtop.location.href = "tabs-X.html"; }
        if(newLevel==1){ parent.rtop.location.href = "tabs-Y.html"; }
        if(newLevel==2){ parent.rtop.location.href = "tabs-Z.html"; }
       	gotomisc((parseInt(newLevel)*100)+(parseInt(newPaper)+99));
}

// =- Function: Miscellaneous Page Change ------------------------------------------=
function envChange(levelObj, envObj, paperObj) {

        var newLevel = levelObj.options[levelObj.selectedIndex].value;
        var newEnv   = envObj.options[envObj.selectedIndex].value;
        var newPaper = paperObj.options[paperObj.selectedIndex].value;

        if(newLevel==0){ var levelValue = 100; }
        if(newLevel==1){ var levelValue = 250; }
        if(newLevel==2){ var levelValue = 400; }

        if(newEnv==1){ var envValue = 0;   }
        if(newEnv==2){ var envValue = 50;  }
        if(newEnv==3){ var envValue = 100; }

        if(newLevel==0){ parent.rtop.location.href = "tabs-X.html"; }
        if(newLevel==1){ parent.rtop.location.href = "tabs-Y.html"; }
        if(newLevel==2){ parent.rtop.location.href = "tabs-Z.html"; }

//        alert(levelValue+envValue+parseInt(newPaper));
        gotoenv(levelValue+envValue+parseInt(newPaper));
}

// =- Function: Carbonless Page Jump -----------------------------------------------= ->
function gotocarbon(newPage) {
        currentPage = parseInt(newPage);

	var strnewpage = new String("pg_");
	var szPageNum = new String(newPage);
        var szPageNumLen = 5 - szPageNum.length;

		for (i = 0; i < szPageNumLen; i++)
	 		 strnewpage += "0";
		strnewpage = strnewpage + szPageNum + ".htm";
		parent.contents.location.href = strnewpage;
}

// =- Function: Carbonless Change --------------------------------------------------= ->
function carbonChange(levelObj, sidesObj, paperObj, calcObj, partsObj, sectionBase) {
        var newLevel = levelObj.options[levelObj.selectedIndex].value;
        var newForm  = sidesObj.options[sidesObj.selectedIndex].value;
        var newPaper = paperObj.options[paperObj.selectedIndex].value;
        var newCalc  = calcObj.options[calcObj.selectedIndex].value;
        var newPart  = partsObj.options[partsObj.selectedIndex].value;
        switch (sectionBase) {
                case 3:  var newSection = 2000;  break;
                case 6:  var newSection = 3200;  break;
                default: var newSection = 0;     break; }

      	gotopage(parseInt(newForm)+(newPaper*12)+(600*newCalc)+(4400*newLevel)+newSection+((parseInt(newPart)*2)-1));
}

// =- Function: Carbon Level Change ------------------------------------------------= ->
function carbonLevelChange(levelObj, sidesObj, paperObj, calcObj, partsObj, sectionBase) {
        var newLevel = levelObj.options[levelObj.selectedIndex].value;
        var newForm  = sidesObj.options[sidesObj.selectedIndex].value;
        var newPaper = paperObj.options[paperObj.selectedIndex].value;
        var newCalc  = calcObj.options[calcObj.selectedIndex].value;
        var newPart  = partsObj.options[partsObj.selectedIndex].value;
        switch (sectionBase) {
                case 3:  var newSection = 2000;  break;
                case 6:  var newSection = 3200;  break;
                default: var newSection = 0;     break; }

        if(newLevel==0){ parent.rtop.location.href = "tabs-X.html"; }
        if(newLevel==1){ parent.rtop.location.href = "tabs-Y.html"; }
        if(newLevel==2){ parent.rtop.location.href = "tabs-Z.html"; }

      	gotopage(parseInt(newForm)+(newPaper*12)+(600*newCalc)+(4400*newLevel)+newSection+((parseInt(newPart)*2)-1));
}

// =- Function: Digital Page Change ------------------------------------------------=
function pageChange(levelObj, formObj, paperObj, calcObj, sectionLevel) {

        var newLevel = levelObj.options[levelObj.selectedIndex].value;
        var newForm  = formObj.options[formObj.selectedIndex].value;
        var newPaper = paperObj.options[paperObj.selectedIndex].value;
        var newCalc  = calcObj.options[calcObj.selectedIndex].value;

        switch (sectionLevel) {
                        case 1: var newSection = 0;     break;
                        case 2: var newSection = 500;   break;
                        case 3: var newSection = 2000;  break;
                        case 4: var newSection = 1000;  break;
                        case 5: var newSection = 1500;  break;
                        case 6: var newSection = 3200;  break;
                        case 7: var newSection = 100;   break;
                        case 8: var newSection = 360;   break;
                       default: var newSection = 0;     break; }

       	gotopage(parseInt(newForm)+((parseInt(newPaper)*10)-9)+(5*parseInt(newCalc))+newSection+(4400*parseInt(newLevel)));
}

// =- Function: Level Change -------------------------------------------------------=
function levelChange(levelObj, formObj, paperObj, calcObj, sectionLevel) {

        var newLevel = levelObj.options[levelObj.selectedIndex].value;
        var newPaper = paperObj.options[paperObj.selectedIndex].value;
        var newForm  = formObj.options[formObj.selectedIndex].value;
        var newCalc  = calcObj.options[calcObj.selectedIndex].value;

        switch (sectionLevel) {
                        case 1: var newSection = 0;     break;
                        case 2: var newSection = 500;   break;
                        case 3: var newSection = 2000;  break;
                        case 4: var newSection = 1000;  break;
                        case 5: var newSection = 1500;  break;
                        case 6: var newSection = 3200;  break;
                        case 7: var newSection = 100;   break;
                        case 8: var newSection = 360;   break;
                       default: var newSection = 0;     break; }

        if(newLevel==0){ parent.rtop.location.href = "tabs-X.html"; }
        if(newLevel==1){ parent.rtop.location.href = "tabs-Y.html"; }
        if(newLevel==2){ parent.rtop.location.href = "tabs-Z.html"; }

       	gotopage(parseInt(newForm)+((parseInt(newPaper)*10)-9)+(5*parseInt(newCalc))+newSection+(4400*parseInt(newLevel)));
}
// =- function: writePersistentCookie ----------------------------------------------=
function writePersistentCookie (CookieName, CookieValue, periodType, offset) {
  var expireDate = new Date ();
      offset = offset / 1;
  var myPeriodType = periodType;
  if(platform == 'mac') {
  switch (myPeriodType.toLowerCase()) {
        case "years":
                var year = expireDate.getYear();
                if (year < 1000) year = year + 1900;
                expireDate.setYear(year + offset);
                break;
        case "months":
                expireDate.setMonth(expireDate.getMonth() + offset);
                break;
        case "days":
                expireDate.setDate(expireDate.getDate() + offset);
                break;
        case "hours":
                expireDate.setHours(expireDate.getHours() + offset);
                break;
        case "minutes":
                expireDate.setMinutes(expireDate.getMinutes() + offset);
                break;
        default:
                // alert ("Invalid periodType parameter for writePersistentCookie()");
                break;
  }
  document.cookie = escape(CookieName ) + "=" + escape(CookieValue) + "; expires=" + expireDate.toGMTString() + "; path=/";
  }
}

// =- Function: Offset Page Change -------------------------------------------------= ->
function offsetPageChange(levelObj, pageObj, paperObj) {

        var newLevel = levelObj.options[levelObj.selectedIndex].value;
	var newPage  = pageObj.options[pageObj.selectedIndex].value;
        var newPaper = paperObj.options[paperObj.selectedIndex].value;
        gotopage((386*parseInt(newLevel))+(parseInt(newPage)+parseInt(newPaper)));
}


// =- Function: Level Change -------------------------------------------------------= ->
function offsetLevelChange(levelObj, pageObj, paperObj) {

        var newLevel = levelObj.options[levelObj.selectedIndex].value;
	var newPage  = pageObj.options[pageObj.selectedIndex].value;
        var newPaper = paperObj.options[paperObj.selectedIndex].value;

        if(newLevel==0){ parent.rtop.location.href = "tabs-x.html"; }
        if(newLevel==1){ parent.rtop.location.href = "tabs-y.html"; }
        if(newLevel==2){ parent.rtop.location.href = "tabs-z.html"; }

        gotopage((386*parseInt(newLevel))+(parseInt(newPage)+parseInt(newPaper)));
}

// =- Function: Empty Paper Cost Array ---------------------------------------------= ->
function emptySelect(selectObj) { var selIndex = selectObj.selectedIndex; for(i=selectObj.length-1; i>=0; i--) { selectObj.options[i] = null; } }

// =- Function: Section Change -----------------------------------------------------= ->
function offsetSectionChange(levelObj, pageObj, paperObj) {

        var newLevel = levelObj.options[levelObj.selectedIndex].value;
	var newPage  = pageObj.options[pageObj.selectedIndex].value;
        var newPaper = 0;
        currentPage  = parseInt(newPage);

        gotopage((386*parseInt(newLevel))+(parseInt(newPage)+parseInt(newPaper)));
        emptySelect(paperObj);
        switch(parseInt(newPage)) {

                case 3:   paperObj.options[0]   = new Option('$4.00 per 1,000', '0');
                          paperObj.options[1]   = new Option('$5.00 per 1,000', '1');
                          paperObj.options[2]   = new Option('$6.00 per 1,000', '2');
                          paperObj.options[3]   = new Option('$7.00 per 1,000', '3');
                          paperObj.options[4]   = new Option('$8.00 per 1,000', '4');
                          paperObj.options[5]   = new Option('$10.00 per 1,000', '5');
                          paperObj.options[6]   = new Option('$12.50 per 1,000', '6');
                          paperObj.options[7]   = new Option('$15.00 per 1,000', '7');
                          paperObj.options[8]   = new Option('ZERO', '8');
                          break;

                case 12:  paperObj.options[0]   = new Option('$4.00 per 1,000', '0');
                          paperObj.options[1]   = new Option('$5.00 per 1,000', '1');
                          paperObj.options[2]   = new Option('$6.00 per 1,000', '2');
                          paperObj.options[3]   = new Option('$7.00 per 1,000', '3');
                          paperObj.options[4]   = new Option('$8.00 per 1,000', '4');
                          paperObj.options[5]   = new Option('$9.00 per 1,000', '5');
                          paperObj.options[6]   = new Option('$10.00 per 1,000', '6');
                          paperObj.options[7]   = new Option('$12.50 per 1,000', '7');
                          paperObj.options[8]   = new Option('$15.00 per 1,000', '8');
                          paperObj.options[9]   = new Option('$17.50 per 1,000', '9');
                          paperObj.options[10]  = new Option('$20.00 per 1,000', '10');
                          paperObj.options[11]  = new Option('$22.50 per 1,000', '11');
                          paperObj.options[12]  = new Option('$25.00 per 1,000', '12');
                          paperObj.options[13]  = new Option('$30.00 per 1,000', '13');
                          paperObj.options[14]  = new Option('$35.00 per 1,000', '14');
                          paperObj.options[15]  = new Option('$40.00 per 1,000', '15');
                          paperObj.options[16]  = new Option('$45.00 per 1,000', '16');
                          paperObj.options[17]  = new Option('$55.00 per 1,000', '17');
                          paperObj.options[18]  = new Option('$65.00 per 1,000', '18');
                          paperObj.options[19]  = new Option('ZERO', '19');
                          break;

                case 32:  paperObj.options[0]   = new Option('$4.00 per 1,000', '0');
                          paperObj.options[1]   = new Option('$5.00 per 1,000', '0');
                          paperObj.options[2]   = new Option('$6.00 per 1,000', '0');
                          paperObj.options[3]   = new Option('$7.00 per 1,000', '0');
                          paperObj.options[4]   = new Option('$8.00 per 1,000', '1');
                          paperObj.options[5]   = new Option('$9.00 per 1,000', '1');
                          paperObj.options[6]   = new Option('$10.00 per 1,000', '1');
                          paperObj.options[7]   = new Option('$12.50 per 1,000', '1');
                          paperObj.options[8]   = new Option('$15.00 per 1,000', '2');
                          paperObj.options[9]   = new Option('$17.50 per 1,000', '2');
                          paperObj.options[10]  = new Option('$20.00 per 1,000', '2');
                          paperObj.options[11]  = new Option('$22.50 per 1,000', '2');
                          paperObj.options[12]  = new Option('$25.00 per 1,000', '3');
                          paperObj.options[13]  = new Option('$30.00 per 1,000', '3');
                          paperObj.options[14]  = new Option('$35.00 per 1,000', '3');
                          paperObj.options[15]  = new Option('$40.00 per 1,000', '3');
                          paperObj.options[16]  = new Option('$45.00 per 1,000', '4');
                          paperObj.options[17]  = new Option('$55.00 per 1,000', '4');
                          paperObj.options[18]  = new Option('$65.00 per 1,000', '4');
                          paperObj.options[19]  = new Option('ZERO', '4');
                          break;

                case 37:  paperObj.options[0]   = new Option('$10.00 per 1,000', '0');
                          paperObj.options[1]   = new Option('$12.50 per 1,000', '0');
                          paperObj.options[2]   = new Option('$15.00 per 1,000', '1');
                          paperObj.options[3]   = new Option('$20.00 per 1,000', '1');
                          paperObj.options[4]   = new Option('$25.00 per 1,000', '2');
                          paperObj.options[5]   = new Option('$30.00 per 1,000', '2');
                          paperObj.options[6]   = new Option('$35.00 per 1,000', '3');
                          paperObj.options[7]   = new Option('$40.00 per 1,000', '3');
                          paperObj.options[8]   = new Option('$45.00 per 1,000', '4');
                          paperObj.options[9]   = new Option('$50.00 per 1,000', '4');
                          paperObj.options[10]  = new Option('$55.00 per 1,000', '5');
                          paperObj.options[11]  = new Option('ZERO', '5');
                          break;

                case 43:  paperObj.options[0]   = new Option('$10.00 per 1,000', '0');
                          paperObj.options[1]   = new Option('$12.50 per 1,000', '0');
                          paperObj.options[2]   = new Option('$15.00 per 1,000', '0');
                          paperObj.options[3]   = new Option('$20.00 per 1,000', '0');
                          paperObj.options[4]   = new Option('$25.00 per 1,000', '1');
                          paperObj.options[5]   = new Option('$30.00 per 1,000', '1');
                          paperObj.options[6]   = new Option('$35.00 per 1,000', '1');
                          paperObj.options[7]   = new Option('$40.00 per 1,000', '1');
                          paperObj.options[8]   = new Option('$45.00 per 1,000', '2');
                          paperObj.options[9]   = new Option('$50.00 per 1,000', '2');
                          paperObj.options[10]  = new Option('$55.00 per 1,000', '2');
                          paperObj.options[11]  = new Option('ZERO', '2');
                          break;

                case 47:  paperObj.options[0]   = new Option('$15.00 per 1,000', '0');
                          paperObj.options[1]   = new Option('$17.50 per 1,000', '1');
                          paperObj.options[2]   = new Option('$20.00 per 1,000', '2');
                          paperObj.options[3]   = new Option('$25.00 per 1,000', '3');
                          paperObj.options[4]   = new Option('$30.00 per 1,000', '4');
                          paperObj.options[5]   = new Option('$35.00 per 1,000', '5');
                          paperObj.options[6]   = new Option('$40.00 per 1,000', '6');
                          paperObj.options[7]   = new Option('$45.00 per 1,000', '7');
                          paperObj.options[8]   = new Option('$50.00 per 1,000', '8');
                          paperObj.options[9]   = new Option('$60.00 per 1,000', '9');
                          paperObj.options[10]  = new Option('$70.00 per 1,000', '10');
                          paperObj.options[11]  = new Option('$80.00 per 1,000', '11');
                          paperObj.options[12]  = new Option('$100.00 per 1,000', '12');
                          paperObj.options[13]  = new Option('$125.00 per 1,000', '13');
                          paperObj.options[14]  = new Option('$150.00 per 1,000', '14');
                          paperObj.options[15]  = new Option('$175.00 per 1,000', '15');
                          paperObj.options[16]  = new Option('$200.00 per 1,000', '16');
                          paperObj.options[17]  = new Option('ZERO', '17');
                          break;

                case 65:  paperObj.options[0]   = new Option('$15.00 per 1,000', '0');
                          paperObj.options[1]   = new Option('$17.50 per 1,000', '0');
                          paperObj.options[2]   = new Option('$20.00 per 1,000', '0');
                          paperObj.options[3]   = new Option('$25.00 per 1,000', '0');
                          paperObj.options[4]   = new Option('$30.00 per 1,000', '1');
                          paperObj.options[5]   = new Option('$35.00 per 1,000', '1');
                          paperObj.options[6]   = new Option('$40.00 per 1,000', '1');
                          paperObj.options[7]   = new Option('$45.00 per 1,000', '1');
                          paperObj.options[8]   = new Option('$50.00 per 1,000', '2');
                          paperObj.options[9]   = new Option('$60.00 per 1,000', '2');
                          paperObj.options[10]  = new Option('$80.00 per 1,000', '2');
                          paperObj.options[11]  = new Option('$125.00 per 1,000', '2');
                          paperObj.options[12]  = new Option('$150.00 per 1,000', '3');
                          paperObj.options[13]  = new Option('$175.00 per 1,000', '3');
                          paperObj.options[14]  = new Option('$200.00 per 1,000', '3');
                          paperObj.options[15]  = new Option('ZERO', '3');
                          break;

                case 69:  paperObj.options[0]   = new Option('$15.00 per 1,000', '0');
                          paperObj.options[1]   = new Option('$17.50 per 1,000', '1');
                          paperObj.options[2]   = new Option('$20.00 per 1,000', '2');
                          paperObj.options[3]   = new Option('$25.00 per 1,000', '3');
                          paperObj.options[4]   = new Option('$30.00 per 1,000', '4');
                          paperObj.options[5]   = new Option('$40.00 per 1,000', '5');
                          paperObj.options[6]   = new Option('$50.00 per 1,000', '6');
                          paperObj.options[7]   = new Option('ZERO', '7');
                          break;

                case 77:  paperObj.options[0]   = new Option('$15.00 per 1,000', '0');
                          paperObj.options[1]   = new Option('$17.50 per 1,000', '0');
                          paperObj.options[2]   = new Option('$20.00 per 1,000', '0');
                          paperObj.options[3]   = new Option('$25.00 per 1,000', '0');
                          paperObj.options[4]   = new Option('$30.00 per 1,000', '1');
                          paperObj.options[5]   = new Option('$40.00 per 1,000', '1');
                          paperObj.options[6]   = new Option('$50.00 per 1,000', '1');
                          paperObj.options[7]   = new Option('ZERO', '1');
                          break;

                case 79:  paperObj.options[0]   = new Option('$30.00 per 1,000', '0');
                          paperObj.options[1]   = new Option('$35.00 per 1,000', '1');
                          paperObj.options[2]   = new Option('$40.00 per 1,000', '2');
                          paperObj.options[3]   = new Option('$50.00 per 1,000', '3');
                          paperObj.options[4]   = new Option('$60.00 per 1,000', '4');
                          paperObj.options[5]   = new Option('$80.00 per 1,000', '5');
                          paperObj.options[6]   = new Option('$100.00 per 1,000', '6');
                          paperObj.options[7]   = new Option('ZERO', '7');
                          break;

                case 87:  paperObj.options[0]   = new Option('$30.00 per 1,000', '0');
                          paperObj.options[1]   = new Option('$35.00 per 1,000', '0');
                          paperObj.options[2]   = new Option('$40.00 per 1,000', '0');
                          paperObj.options[3]   = new Option('$50.00 per 1,000', '0');
                          paperObj.options[4]   = new Option('$60.00 per 1,000', '1');
                          paperObj.options[5]   = new Option('$80.00 per 1,000', '1');
                          paperObj.options[6]   = new Option('$100.00 per 1,000', '1');
                          paperObj.options[7]   = new Option('ZERO', '1');
                          break;

                case 89:  paperObj.options[0]   = new Option('$10.00 per 1,000', '0');
                          paperObj.options[1]   = new Option('$15.00 per 1,000', '1');
                          paperObj.options[2]   = new Option('$20.00 per 1,000', '2');
                          paperObj.options[3]   = new Option('$22.50 per 1,000', '3');
                          paperObj.options[4]   = new Option('$25.00 per 1,000', '4');
                          paperObj.options[5]   = new Option('$27.50 per 1,000', '5');
                          paperObj.options[6]   = new Option('$30.00 per 1,000', '6');
                          paperObj.options[7]   = new Option('$32.50 per 1,000', '7');
                          paperObj.options[8]   = new Option('$35.00 per 1,000', '8');
                          paperObj.options[9]   = new Option('$40.00 per 1,000', '9');
                          paperObj.options[10]  = new Option('$45.00 per 1,000', '10');
                          paperObj.options[11]  = new Option('$50.00 per 1,000', '11');
                          paperObj.options[12]  = new Option('$55.00 per 1,000', '12');
                          paperObj.options[13]  = new Option('$60.00 per 1,000', '13');
                          paperObj.options[14]  = new Option('$65.00 per 1,000', '14');
                          paperObj.options[15]  = new Option('$70.00 per 1,000', '15');
                          paperObj.options[16]  = new Option('$75.00 per 1,000', '16');
                          paperObj.options[17]  = new Option('$80.00 per 1,000', '17');
                          paperObj.options[18]  = new Option('$90.00 per 1,000', '18');
                          paperObj.options[19]  = new Option('$100.00 per 1,000', '19');
                          paperObj.options[20]  = new Option('$120.00 per 1,000', '20');
                          paperObj.options[21]  = new Option('$140.00 per 1,000', '21');
                          paperObj.options[22]  = new Option('$160.00 per 1,000', '22');
                          paperObj.options[23]  = new Option('$180.00 per 1,000', '23');
                          paperObj.options[24]  = new Option('$200.00 per 1,000', '24');
                          paperObj.options[25]  = new Option('$300.00 per 1,000', '25');
                          paperObj.options[26]  = new Option('$400.00 per 1,000', '26');
                          paperObj.options[27]  = new Option('ZERO', '27');
                          break;

                case 117: paperObj.options[0]   = new Option('$10.00 per 1,000', '0');
                          paperObj.options[1]   = new Option('$15.00 per 1,000', '0');
                          paperObj.options[2]   = new Option('$20.00 per 1,000', '0');
                          paperObj.options[3]   = new Option('$25.00 per 1,000', '0');
                          paperObj.options[4]   = new Option('$30.00 per 1,000', '1');
                          paperObj.options[5]   = new Option('$35.00 per 1,000', '1');
                          paperObj.options[6]   = new Option('$40.00 per 1,000', '1');
                          paperObj.options[7]   = new Option('$45.00 per 1,000', '1');
                          paperObj.options[8]   = new Option('$50.00 per 1,000', '2');
                          paperObj.options[9]   = new Option('$55.00 per 1,000', '2');
                          paperObj.options[10]  = new Option('$60.00 per 1,000', '2');
                          paperObj.options[11]  = new Option('$65.00 per 1,000', '2');
                          paperObj.options[12]  = new Option('$70.00 per 1,000', '3');
                          paperObj.options[13]  = new Option('$80.00 per 1,000', '3');
                          paperObj.options[14]  = new Option('$90.00 per 1,000', '3');
                          paperObj.options[15]  = new Option('$100.00 per 1,000', '3');
                          paperObj.options[16]  = new Option('$120.00 per 1,000', '4');
                          paperObj.options[17]  = new Option('$140.00 per 1,000', '4');
                          paperObj.options[18]  = new Option('$160.00 per 1,000', '4');
                          paperObj.options[19]  = new Option('$180.00 per 1,000', '4');
                          paperObj.options[20]  = new Option('$200.00 per 1,000', '5');
                          paperObj.options[21]  = new Option('$300.00 per 1,000', '5');
                          paperObj.options[22]  = new Option('$400.00 per 1,000', '5');
                          paperObj.options[23]  = new Option('ZERO', '5');
                          break;

                case 123: paperObj.options[0]   = new Option('$10.00 per 1,000', '0');
                          paperObj.options[1]   = new Option('$15.00 per 1,000', '0');
                          paperObj.options[2]   = new Option('$17.50 per 1,000', '1');
                          paperObj.options[3]   = new Option('$20.00 per 1,000', '1');
                          paperObj.options[4]   = new Option('$25.00 per 1,000', '2');
                          paperObj.options[5]   = new Option('$30.00 per 1,000', '2');
                          paperObj.options[6]   = new Option('$40.00 per 1,000', '3');
                          paperObj.options[7]   = new Option('$50.00 per 1,000', '3');
                          paperObj.options[8]   = new Option('$40.00 per 1,000', '3');
                          paperObj.options[9]   = new Option('$50.00 per 1,000', '3');
                          paperObj.options[10]  = new Option('$60.00 per 1,000', '4');
                          paperObj.options[11]  = new Option('ZERO', '4');
                          break;

                case 128: paperObj.options[0]   = new Option('$10.00 per 1,000', '0');
                          paperObj.options[1]   = new Option('$15.00 per 1,000', '0');
                          paperObj.options[2]   = new Option('$17.50 per 1,000', '0');
                          paperObj.options[3]   = new Option('$20.00 per 1,000', '0');
                          paperObj.options[4]   = new Option('$25.00 per 1,000', '1');
                          paperObj.options[5]   = new Option('$30.00 per 1,000', '1');
                          paperObj.options[6]   = new Option('$40.00 per 1,000', '1');
                          paperObj.options[7]   = new Option('$50.00 per 1,000', '1');
                          paperObj.options[8]   = new Option('$40.00 per 1,000', '2');
                          paperObj.options[9]   = new Option('$50.00 per 1,000', '2');
                          paperObj.options[10]  = new Option('$60.00 per 1,000', '2');
                          paperObj.options[11]  = new Option('ZERO', '2');
                          break;

                case 130: paperObj.options[0]   = new Option('$20.00 per 1,000', '0');
                          paperObj.options[1]   = new Option('$30.00 per 1,000', '0');
                          paperObj.options[2]   = new Option('$40.00 per 1,000', '1');
                          paperObj.options[3]   = new Option('$50.00 per 1,000', '1');
                          paperObj.options[4]   = new Option('$60.00 per 1,000', '2');
                          paperObj.options[5]   = new Option('$70.00 per 1,000', '2');
                          paperObj.options[6]   = new Option('$80.00 per 1,000', '3');
                          paperObj.options[7]   = new Option('$90.00 per 1,000', '3');
                          paperObj.options[8]   = new Option('$100.00 per 1,000', '4');
                          paperObj.options[9]   = new Option('$110.00 per 1,000', '4');
                          paperObj.options[10]  = new Option('$120.00 per 1,000', '5');
                          paperObj.options[11]  = new Option('ZERO', '5');
                          break;

                case 136: paperObj.options[0]   = new Option('$20.00 per 1,000', '0');
                          paperObj.options[1]   = new Option('$30.00 per 1,000', '0');
                          paperObj.options[2]   = new Option('$40.00 per 1,000', '0');
                          paperObj.options[3]   = new Option('$50.00 per 1,000', '0');
                          paperObj.options[4]   = new Option('$60.00 per 1,000', '1');
                          paperObj.options[5]   = new Option('$70.00 per 1,000', '1');
                          paperObj.options[6]   = new Option('$80.00 per 1,000', '1');
                          paperObj.options[7]   = new Option('$90.00 per 1,000', '1');
                          paperObj.options[8]   = new Option('$100.00 per 1,000', '2');
                          paperObj.options[9]   = new Option('$110.00 per 1,000', '2');
                          paperObj.options[10]  = new Option('$120.00 per 1,000', '2');
                          paperObj.options[11]  = new Option('ZERO', '2');
                          break;

                case 139: paperObj.options[0]   = new Option('$30.00 per 1,000', '0');
                          paperObj.options[1]   = new Option('$40.00 per 1,000', '0');
                          paperObj.options[2]   = new Option('$50.00 per 1,000', '1');
                          paperObj.options[3]   = new Option('$60.00 per 1,000', '1');
                          paperObj.options[4]   = new Option('$70.00 per 1,000', '2');
                          paperObj.options[5]   = new Option('$80.00 per 1,000', '2');
                          paperObj.options[6]   = new Option('$90.00 per 1,000', '3');
                          paperObj.options[7]   = new Option('ZERO', '3');
                          break;

                case 143: paperObj.options[0]   = new Option('$30.00 per 1,000', '0');
                          paperObj.options[1]   = new Option('$40.00 per 1,000', '0');
                          paperObj.options[2]   = new Option('$50.00 per 1,000', '0');
                          paperObj.options[3]   = new Option('$60.00 per 1,000', '0');
                          paperObj.options[4]   = new Option('$70.00 per 1,000', '1');
                          paperObj.options[5]   = new Option('$80.00 per 1,000', '1');
                          paperObj.options[6]   = new Option('$90.00 per 1,000', '1');
                          paperObj.options[7]   = new Option('ZERO', '1');
                          break;

                case 145: paperObj.options[0]   = new Option('$30.00 per 1,000', '0');
                          paperObj.options[1]   = new Option('$40.00 per 1,000', '0');
                          paperObj.options[2]   = new Option('$50.00 per 1,000', '1');
                          paperObj.options[3]   = new Option('$60.00 per 1,000', '1');
                          paperObj.options[4]   = new Option('$80.00 per 1,000', '2');
                          paperObj.options[5]   = new Option('$100.00 per 1,000', '2');
                          paperObj.options[6]   = new Option('$125.00 per 1,000', '3');
                          paperObj.options[7]   = new Option('$150.00 per 1,000', '3');
                          paperObj.options[8]   = new Option('$175.00 per 1,000', '4');
                          paperObj.options[9]   = new Option('$200.00 per 1,000', '4');
                          paperObj.options[10]  = new Option('$225.00 per 1,000', '5');
                          paperObj.options[11]  = new Option('ZERO', '5');
                          break;

                case 151: paperObj.options[0]   = new Option('$30.00 per 1,000', '0');
                          paperObj.options[1]   = new Option('$40.00 per 1,000', '0');
                          paperObj.options[2]   = new Option('$50.00 per 1,000', '0');
                          paperObj.options[3]   = new Option('$60.00 per 1,000', '0');
                          paperObj.options[4]   = new Option('$80.00 per 1,000', '1');
                          paperObj.options[5]   = new Option('$100.00 per 1,000', '1');
                          paperObj.options[6]   = new Option('$125.00 per 1,000', '1');
                          paperObj.options[7]   = new Option('$150.00 per 1,000', '1');
                          paperObj.options[8]   = new Option('$175.00 per 1,000', '2');
                          paperObj.options[9]   = new Option('$200.00 per 1,000', '2');
                          paperObj.options[10]  = new Option('$225.00 per 1,000', '2');
                          paperObj.options[11]  = new Option('ZERO', '2');
                          break;

                case 155: paperObj.options[0]   = new Option('$15.00 per 1,000', '0');
                          paperObj.options[1]   = new Option('$20.00 per 1,000', '1');
                          paperObj.options[2]   = new Option('$30.00 per 1,000', '2');
                          paperObj.options[3]   = new Option('$40.00 per 1,000', '3');
                          paperObj.options[4]   = new Option('$50.00 per 1,000', '4');
                          paperObj.options[5]   = new Option('$60.00 per 1,000', '5');
                          paperObj.options[6]   = new Option('$70.00 per 1,000', '6');
                          paperObj.options[7]   = new Option('ZERO', '7');
                          break;

                case 163: paperObj.options[0]   = new Option('$15.00 per 1,000', '0');
                          paperObj.options[1]   = new Option('$20.00 per 1,000', '0');
                          paperObj.options[2]   = new Option('$30.00 per 1,000', '0');
                          paperObj.options[3]   = new Option('$40.00 per 1,000', '0');
                          paperObj.options[4]   = new Option('$50.00 per 1,000', '1');
                          paperObj.options[5]   = new Option('$60.00 per 1,000', '1');
                          paperObj.options[6]   = new Option('$70.00 per 1,000', '1');
                          paperObj.options[7]   = new Option('ZERO', '1');
                          break;

                case 165: paperObj.options[0]   = new Option('$15.00 per 1,000', '0');
                          paperObj.options[1]   = new Option('$20.00 per 1,000', '1');
                          paperObj.options[2]   = new Option('$30.00 per 1,000', '2');
                          paperObj.options[3]   = new Option('$40.00 per 1,000', '3');
                          paperObj.options[4]   = new Option('$50.00 per 1,000', '4');
                          paperObj.options[5]   = new Option('$60.00 per 1,000', '5');
                          paperObj.options[6]   = new Option('$70.00 per 1,000', '6');
                          paperObj.options[7]   = new Option('ZERO', '7');
                          break;

                case 173: paperObj.options[0]   = new Option('$15.00 per 1,000', '0');
                          paperObj.options[1]   = new Option('$20.00 per 1,000', '0');
                          paperObj.options[2]   = new Option('$30.00 per 1,000', '0');
                          paperObj.options[3]   = new Option('$40.00 per 1,000', '0');
                          paperObj.options[4]   = new Option('$50.00 per 1,000', '1');
                          paperObj.options[5]   = new Option('$60.00 per 1,000', '1');
                          paperObj.options[6]   = new Option('$70.00 per 1,000', '1');
                          paperObj.options[7]   = new Option('ZERO', '1');
                          break;

                case 175: paperObj.options[0]   = new Option('$15.00 per 1,000', '0');
                          paperObj.options[1]   = new Option('$20.00 per 1,000', '1');
                          paperObj.options[2]   = new Option('$30.00 per 1,000', '2');
                          paperObj.options[3]   = new Option('$40.00 per 1,000', '3');
                          paperObj.options[4]   = new Option('$50.00 per 1,000', '4');
                          paperObj.options[5]   = new Option('$60.00 per 1,000', '5');
                          paperObj.options[6]   = new Option('$70.00 per 1,000', '6');
                          paperObj.options[7]   = new Option('ZERO', '7');
                          break;

                case 183: paperObj.options[0]   = new Option('$15.00 per 1,000', '0');
                          paperObj.options[1]   = new Option('$20.00 per 1,000', '0');
                          paperObj.options[2]   = new Option('$30.00 per 1,000', '0');
                          paperObj.options[3]   = new Option('$40.00 per 1,000', '0');
                          paperObj.options[4]   = new Option('$50.00 per 1,000', '1');
                          paperObj.options[5]   = new Option('$60.00 per 1,000', '1');
                          paperObj.options[6]   = new Option('$70.00 per 1,000', '1');
                          paperObj.options[7]   = new Option('ZERO', '1');
                          break;

                case 185: paperObj.options[0]   = new Option('$25.00 per 1,000', '0');
                          paperObj.options[1]   = new Option('$30.00 per 1,000', '1');
                          paperObj.options[2]   = new Option('$40.00 per 1,000', '2');
                          paperObj.options[3]   = new Option('$50.00 per 1,000', '3');
                          paperObj.options[4]   = new Option('$60.00 per 1,000', '4');
                          paperObj.options[5]   = new Option('$70.00 per 1,000', '5');
                          paperObj.options[6]   = new Option('$80.00 per 1,000', '6');
                          paperObj.options[7]   = new Option('ZERO', '7');
                          break;

                case 193: paperObj.options[0]   = new Option('$25.00 per 1,000', '0');
                          paperObj.options[1]   = new Option('$30.00 per 1,000', '0');
                          paperObj.options[2]   = new Option('$40.00 per 1,000', '0');
                          paperObj.options[3]   = new Option('$50.00 per 1,000', '0');
                          paperObj.options[4]   = new Option('$60.00 per 1,000', '1');
                          paperObj.options[5]   = new Option('$70.00 per 1,000', '1');
                          paperObj.options[6]   = new Option('$80.00 per 1,000', '1');
                          paperObj.options[7]   = new Option('ZERO', '1');
                          break;

                case 195: paperObj.options[0]   = new Option('$25.00 per 1,000', '0');
                          paperObj.options[1]   = new Option('$30.00 per 1,000', '1');
                          paperObj.options[2]   = new Option('$40.00 per 1,000', '2');
                          paperObj.options[3]   = new Option('$50.00 per 1,000', '3');
                          paperObj.options[4]   = new Option('$60.00 per 1,000', '4');
                          paperObj.options[5]   = new Option('$70.00 per 1,000', '5');
                          paperObj.options[6]   = new Option('$80.00 per 1,000', '6');
                          paperObj.options[7]   = new Option('ZERO', '7');
                          break;

                case 203: paperObj.options[0]   = new Option('$25.00 per 1,000', '0');
                          paperObj.options[1]   = new Option('$30.00 per 1,000', '0');
                          paperObj.options[2]   = new Option('$40.00 per 1,000', '0');
                          paperObj.options[3]   = new Option('$50.00 per 1,000', '0');
                          paperObj.options[4]   = new Option('$60.00 per 1,000', '1');
                          paperObj.options[5]   = new Option('$70.00 per 1,000', '1');
                          paperObj.options[6]   = new Option('$80.00 per 1,000', '1');
                          paperObj.options[7]   = new Option('ZERO', '1');
                          break;

                case 205: paperObj.options[0]   = new Option('$30.00 per 1,000', '0');
                          paperObj.options[1]   = new Option('$50.00 per 1,000', '0');
                          paperObj.options[2]   = new Option('$70.00 per 1,000', '0');
                          paperObj.options[3]   = new Option('ZERO', '0');
                          break;

                case 206: paperObj.options[0]   = new Option('$30.00 per 1,000', '0');
                          paperObj.options[1]   = new Option('$50.00 per 1,000', '0');
                          paperObj.options[2]   = new Option('$70.00 per 1,000', '0');
                          paperObj.options[3]   = new Option('ZERO', '0');
                          break;

                case 207: paperObj.options[0]   = new Option('$30.00 per 1,000', '0');
                          paperObj.options[1]   = new Option('$50.00 per 1,000', '0');
                          paperObj.options[2]   = new Option('$70.00 per 1,000', '0');
                          paperObj.options[3]   = new Option('ZERO', '0');
                          break;

                case 208: paperObj.options[0]   = new Option('$30.00 per 1,000', '0');
                          paperObj.options[1]   = new Option('$50.00 per 1,000', '0');
                          paperObj.options[2]   = new Option('$70.00 per 1,000', '0');
                          paperObj.options[3]   = new Option('ZERO', '0');
                          break;

                case 209: paperObj.options[0]   = new Option('$30.00 per 1,000', '0');
                          paperObj.options[1]   = new Option('$50.00 per 1,000', '0');
                          paperObj.options[2]   = new Option('$70.00 per 1,000', '0');
                          paperObj.options[3]   = new Option('ZERO', '0');
                          break;

                case 210: paperObj.options[0]   = new Option('$30.00 per 1,000', '0');
                          paperObj.options[1]   = new Option('$50.00 per 1,000', '0');
                          paperObj.options[2]   = new Option('$70.00 per 1,000', '0');
                          paperObj.options[3]   = new Option('ZERO', '0');
                          break;

                case 211: paperObj.options[0]   = new Option('$30.00 per 1,000', '0');
                          paperObj.options[1]   = new Option('$50.00 per 1,000', '0');
                          paperObj.options[2]   = new Option('$70.00 per 1,000', '0');
                          paperObj.options[3]   = new Option('ZERO', '0');
                          break;

                case 212: paperObj.options[0]   = new Option('$30.00 per 1,000', '0');
                          paperObj.options[1]   = new Option('$50.00 per 1,000', '0');
                          paperObj.options[2]   = new Option('$70.00 per 1,000', '0');
                          paperObj.options[3]   = new Option('ZERO', '0');
                          break;

                case 213: paperObj.options[0] = new Option('$30.00 per 1,000', '0');
                          paperObj.options[1] = new Option('$50.00 per 1,000', '0');
                          paperObj.options[2] = new Option('$70.00 per 1,000', '0');
                          paperObj.options[3] = new Option('ZERO', '0');
                          break;

                case 214: paperObj.options[0]   = new Option('$30.00 per 1,000', '0');
                          paperObj.options[1]   = new Option('$50.00 per 1,000', '0');
                          paperObj.options[2]   = new Option('$70.00 per 1,000', '0');
                          paperObj.options[3]   = new Option('ZERO', '0');
                          break;

                case 215: paperObj.options[0]   = new Option('$15.00 per 1,000', '0');
                          paperObj.options[1]   = new Option('$20.00 per 1,000', '0');
                          paperObj.options[2]   = new Option('$30.00 per 1,000', '0');
                          paperObj.options[3]   = new Option('$40.00 per 1,000', '0');
                          paperObj.options[4]   = new Option('$50.00 per 1,000', '1');
                          paperObj.options[5]   = new Option('$60.00 per 1,000', '1');
                          paperObj.options[6]   = new Option('$70.00 per 1,000', '1');
                          paperObj.options[7]   = new Option('ZERO', '1');
                          break;

                case 217: paperObj.options[0]   = new Option('$15.00 per 1,000', '0');
                          paperObj.options[1]   = new Option('$20.00 per 1,000', '0');
                          paperObj.options[2]   = new Option('$30.00 per 1,000', '0');
                          paperObj.options[3]   = new Option('$40.00 per 1,000', '0');
                          paperObj.options[4]   = new Option('$50.00 per 1,000', '1');
                          paperObj.options[5]   = new Option('$60.00 per 1,000', '1');
                          paperObj.options[6]   = new Option('$70.00 per 1,000', '1');
                          paperObj.options[7]   = new Option('ZERO', '1');
                          break;

                case 219: paperObj.options[0]   = new Option('$50.00 per 1,000', '0');
                          paperObj.options[1]   = new Option('$60.00 per 1,000', '0');
                          paperObj.options[2]   = new Option('$70.00 per 1,000', '0');
                          paperObj.options[3]   = new Option('$80.00 per 1,000', '0');
                          paperObj.options[4]   = new Option('$90.00 per 1,000', '1');
                          paperObj.options[5]   = new Option('$100.00 per 1,000', '1');
                          paperObj.options[6]   = new Option('$110.00 per 1,000', '1');
                          paperObj.options[7]   = new Option('ZERO', '1');
                          break;

                case 221: paperObj.options[0]   = new Option('$50.00 per 1,000', '0');
                          paperObj.options[1]   = new Option('$60.00 per 1,000', '0');
                          paperObj.options[2]   = new Option('$70.00 per 1,000', '0');
                          paperObj.options[3]   = new Option('$80.00 per 1,000', '0');
                          paperObj.options[4]   = new Option('$90.00 per 1,000', '1');
                          paperObj.options[5]   = new Option('$100.00 per 1,000', '1');
                          paperObj.options[6]   = new Option('$110.00 per 1,000', '1');
                          paperObj.options[7]   = new Option('ZERO', '1');
                          break;

                case 223: paperObj.options[0]   = new Option('$10.00 per 1,000', '0');
                          paperObj.options[1]   = new Option('$12.00 per 1,000', '0');
                          paperObj.options[2]   = new Option('$14.00 per 1,000', '0');
                          paperObj.options[3]   = new Option('$16.00 per 1,000', '0');
                          paperObj.options[4]   = new Option('$20.00 per 1,000', '1');
                          paperObj.options[5]   = new Option('$25.00 per 1,000', '1');
                          paperObj.options[6]   = new Option('$30.00 per 1,000', '1');
                          paperObj.options[7]   = new Option('$35.00 per 1,000', '1');
                          paperObj.options[8]   = new Option('$40.00 per 1,000', '2');
                          paperObj.options[9]   = new Option('$45.00 per 1,000', '2');
                          paperObj.options[10]  = new Option('$50.00 per 1,000', '2');
                          paperObj.options[11]  = new Option('$55.00 per 1,000', '2');
                          paperObj.options[12]  = new Option('$60.00 per 1,000', '3');
                          paperObj.options[13]  = new Option('$65.00 per 1,000', '3');
                          paperObj.options[14]  = new Option('$70.00 per 1,000', '3');
                          paperObj.options[15]  = new Option('$80.00 per 1,000', '3');
                          paperObj.options[16]  = new Option('$90.00 per 1,000', '4');
                          paperObj.options[17]  = new Option('$95.00 per 1,000', '4');
                          paperObj.options[18]  = new Option('$100.00 per 1,000', '4');
                          paperObj.options[19]  = new Option('$110.00 per 1,000', '4');
                          paperObj.options[20]  = new Option('$120.00 per 1,000', '5');
                          paperObj.options[21]  = new Option('$130.00 per 1,000', '5');
                          paperObj.options[22]  = new Option('$140.00 per 1,000', '5');
                          paperObj.options[23]  = new Option('ZERO', '5');
                          break;

                case 229: paperObj.options[0]   = new Option('$10.00 per 1,000', '0');
                          paperObj.options[1]   = new Option('$12.00 per 1,000', '0');
                          paperObj.options[2]   = new Option('$14.00 per 1,000', '0');
                          paperObj.options[3]   = new Option('$16.00 per 1,000', '0');
                          paperObj.options[4]   = new Option('$20.00 per 1,000', '1');
                          paperObj.options[5]   = new Option('$25.00 per 1,000', '1');
                          paperObj.options[6]   = new Option('$30.00 per 1,000', '1');
                          paperObj.options[7]   = new Option('$35.00 per 1,000', '1');
                          paperObj.options[8]   = new Option('$40.00 per 1,000', '2');
                          paperObj.options[9]   = new Option('$45.00 per 1,000', '2');
                          paperObj.options[10]  = new Option('$50.00 per 1,000', '2');
                          paperObj.options[11]  = new Option('$55.00 per 1,000', '2');
                          paperObj.options[12]  = new Option('$60.00 per 1,000', '3');
                          paperObj.options[13]  = new Option('$65.00 per 1,000', '3');
                          paperObj.options[14]  = new Option('$70.00 per 1,000', '3');
                          paperObj.options[15]  = new Option('$80.00 per 1,000', '3');
                          paperObj.options[16]  = new Option('$90.00 per 1,000', '4');
                          paperObj.options[17]  = new Option('$95.00 per 1,000', '4');
                          paperObj.options[18]  = new Option('$100.00 per 1,000', '4');
                          paperObj.options[19]  = new Option('$110.00 per 1,000', '4');
                          paperObj.options[20]  = new Option('$120.00 per 1,000', '5');
                          paperObj.options[21]  = new Option('$130.00 per 1,000', '5');
                          paperObj.options[22]  = new Option('$140.00 per 1,000', '5');
                          paperObj.options[23]  = new Option('ZERO', '5');
                          break;

                case 235: paperObj.options[0]   = new Option('$9.00 per 1,000', '0');
                          paperObj.options[1]   = new Option('$11.00 per 1,000', '0');
                          paperObj.options[2]   = new Option('$13.00 per 1,000', '0');
                          paperObj.options[3]   = new Option('$15.00 per 1,000', '0');
                          paperObj.options[4]   = new Option('$17.50 per 1,000', '1');
                          paperObj.options[5]   = new Option('$20.00 per 1,000', '1');
                          paperObj.options[6]   = new Option('$25.00 per 1,000', '1');
                          paperObj.options[7]   = new Option('$30.00 per 1,000', '1');
                          paperObj.options[8]   = new Option('$35.00 per 1,000', '2');
                          paperObj.options[9]   = new Option('$40.00 per 1,000', '2');
                          paperObj.options[10]  = new Option('$45.00 per 1,000', '2');
                          paperObj.options[11]  = new Option('$50.00 per 1,000', '2');
                          paperObj.options[12]  = new Option('$55.00 per 1,000', '3');
                          paperObj.options[13]  = new Option('$60.00 per 1,000', '3');
                          paperObj.options[14]  = new Option('$70.00 per 1,000', '3');
                          paperObj.options[15]  = new Option('ZERO', '3');
                          break;

                case 239: paperObj.options[0] = new Option('$9.00 per 1,000', '0');
                          paperObj.options[1]   = new Option('$11.00 per 1,000', '0');
                          paperObj.options[2]   = new Option('$13.00 per 1,000', '0');
                          paperObj.options[3]   = new Option('$15.00 per 1,000', '0');
                          paperObj.options[4]   = new Option('$17.50 per 1,000', '1');
                          paperObj.options[5]   = new Option('$20.00 per 1,000', '1');
                          paperObj.options[6]   = new Option('$25.00 per 1,000', '1');
                          paperObj.options[7]   = new Option('$30.00 per 1,000', '1');
                          paperObj.options[8]   = new Option('$35.00 per 1,000', '2');
                          paperObj.options[9]   = new Option('$40.00 per 1,000', '2');
                          paperObj.options[10]  = new Option('$45.00 per 1,000', '2');
                          paperObj.options[11]  = new Option('$50.00 per 1,000', '2');
                          paperObj.options[12]  = new Option('$55.00 per 1,000', '3');
                          paperObj.options[13]  = new Option('$60.00 per 1,000', '3');
                          paperObj.options[14]  = new Option('$70.00 per 1,000', '3');
                          paperObj.options[15]  = new Option('ZERO', '3');
                          break;

                case 243: paperObj.options[0]   = new Option('$25.00 per 1,000','0');
                          paperObj.options[1]   = new Option('$30.00 per 1,000','0');
                          paperObj.options[2]   = new Option('$35.00 per 1,000','0');
                          paperObj.options[3]   = new Option('$40.00 per 1,000','0');
                          paperObj.options[4]   = new Option('$45.00 per 1,000','1');
                          paperObj.options[5]   = new Option('$50.00 per 1,000','1');
                          paperObj.options[6]   = new Option('$55.00 per 1,000','1');
                          paperObj.options[7]   = new Option('$60.00 per 1,000','1');
                          paperObj.options[8]   = new Option('$65.00 per 1,000','2');
                          paperObj.options[9]   = new Option('$70.00 per 1,000','2');
                          paperObj.options[10]  = new Option('$80.00 per 1,000','2');
                          paperObj.options[11]  = new Option('$90.00 per 1,000','2');
                          paperObj.options[12]  = new Option('$100.00 per 1,000','3');
                          paperObj.options[13]  = new Option('$120.00 per 1,000','3');
                          paperObj.options[14]  = new Option('$140.00 per 1,000','3');
                          paperObj.options[15]  = new Option('ZERO','3');
                          break;

                case 247: paperObj.options[0]   = new Option('$40.00 per 1,000','0');
                          paperObj.options[1]   = new Option('$50.00 per 1,000','0');
                          paperObj.options[2]   = new Option('$60.00 per 1,000','0');
                          paperObj.options[3]   = new Option('ZERO','0');
                          break;

                case 248: paperObj.options[0]   = new Option('$40.00 per 1,000','0');
                          paperObj.options[1]   = new Option('$50.00 per 1,000','0');
                          paperObj.options[2]   = new Option('$60.00 per 1,000','0');
                          paperObj.options[3]   = new Option('ZERO','0');
                          break;

                case 249: paperObj.options[0]   = new Option('$20.00 per 1,000','0');
                          paperObj.options[1]   = new Option('$25.00 per 1,000','0');
                          paperObj.options[2]   = new Option('$30.00 per 1,000','0');
                          paperObj.options[3]   = new Option('$35.00 per 1,000','0');
                          paperObj.options[4]   = new Option('$40.00 per 1,000','1');
                          paperObj.options[5]   = new Option('$45.00 per 1,000','1');
                          paperObj.options[6]   = new Option('$50.00 per 1,000','1');
                          paperObj.options[7]   = new Option('$60.00 per 1,000','1');
                          paperObj.options[8]   = new Option('$70.00 per 1,000','2');
                          paperObj.options[9]   = new Option('$80.00 per 1,000','2');
                          paperObj.options[10]  = new Option('$90.00 per 1,000','2');
                          paperObj.options[11]  = new Option('ZERO','2');
                          break;

                case 252: paperObj.options[0]   = new Option('$20.00 per 1,000','0');
                          paperObj.options[1]   = new Option('$25.00 per 1,000','0');
                          paperObj.options[2]   = new Option('$30.00 per 1,000','0');
                          paperObj.options[3]   = new Option('$35.00 per 1,000','0');
                          paperObj.options[4]   = new Option('$40.00 per 1,000','1');
                          paperObj.options[5]   = new Option('$45.00 per 1,000','1');
                          paperObj.options[6]   = new Option('$50.00 per 1,000','1');
                          paperObj.options[7]   = new Option('$55.00 per 1,000','1');
                          paperObj.options[8]   = new Option('$60.00 per 1,000','2');
                          paperObj.options[9]   = new Option('$65.00 per 1,000','2');
                          paperObj.options[10]  = new Option('$70.00 per 1,000','2');
                          paperObj.options[11]  = new Option('ZERO','2');
                          break;

                case 255: paperObj.options[0]   = new Option('$15.00 per 1,000','0');
                          paperObj.options[1]   = new Option('$20.00 per 1,000','0');
                          paperObj.options[2]   = new Option('$30.00 per 1,000','0');
                          paperObj.options[3]   = new Option('$40.00 per 1,000','0');
                          paperObj.options[4]   = new Option('$50.00 per 1,000','1');
                          paperObj.options[5]   = new Option('$60.00 per 1,000','1');
                          paperObj.options[6]   = new Option('$70.00 per 1,000','1');
                          paperObj.options[7]   = new Option('$80.00 per 1,000','1');
                          paperObj.options[8]   = new Option('$90.00 per 1,000','2');
                          paperObj.options[9]   = new Option('$100.00 per 1,000','2');
                          paperObj.options[10]  = new Option('$125.00 per 1,000','2');
                          paperObj.options[11]  = new Option('ZERO','2');
                          break;

                case 258: paperObj.options[0]   = new Option('$15.00 per 1,000','0');
                          paperObj.options[1]   = new Option('$20.00 per 1,000','0');
                          paperObj.options[2]   = new Option('$30.00 per 1,000','0');
                          paperObj.options[3]   = new Option('$40.00 per 1,000','0');
                          paperObj.options[4]   = new Option('$50.00 per 1,000','1');
                          paperObj.options[5]   = new Option('$60.00 per 1,000','1');
                          paperObj.options[6]   = new Option('$70.00 per 1,000','1');
                          paperObj.options[7]   = new Option('$80.00 per 1,000','1');
                          paperObj.options[8]   = new Option('$90.00 per 1,000','2');
                          paperObj.options[9]   = new Option('$100.00 per 1,000','2');
                          paperObj.options[10]  = new Option('$125.00 per 1,000','2');
                          paperObj.options[11]  = new Option('ZERO','2');
                          break;

                case 261: paperObj.options[0]   = new Option('$25.00 per 1,000', '0');
                          paperObj.options[1]   = new Option('$30.00 per 1,000', '0');
                          paperObj.options[2]   = new Option('$35.00 per 1,000', '1');
                          paperObj.options[3]   = new Option('$40.00 per 1,000', '1');
                          paperObj.options[4]   = new Option('$45.00 per 1,000', '2');
                          paperObj.options[5]   = new Option('ZERO', '2');
                          break;

                case 264: paperObj.options[0]   = new Option('$25.00 per 1,000', '0');
                          paperObj.options[1]   = new Option('$30.00 per 1,000', '0');
                          paperObj.options[2]   = new Option('$35.00 per 1,000', '1');
                          paperObj.options[3]   = new Option('$40.00 per 1,000', '1');
                          paperObj.options[4]   = new Option('$45.00 per 1,000', '2');
                          paperObj.options[5]   = new Option('ZERO', '2');
                          break;

                case 267: paperObj.options[0]   = new Option('$80.00 per 1,000', '0');
                          paperObj.options[1]   = new Option('$100.00 per 1,000', '0');
                          paperObj.options[2]   = new Option('$150.00 per 1,000', '1');
                          paperObj.options[3]   = new Option('$200.00 per 1,000', '1');
                          paperObj.options[4]   = new Option('$250.00 per 1,000', '2');
                          paperObj.options[5]   = new Option('$300.00 per 1,000', '2');
                          paperObj.options[6]   = new Option('$350.00 per 1,000', '3');
                          paperObj.options[7]   = new Option('ZERO', '3');
                          break;

                case 271: paperObj.options[0]   = new Option('$80.00 per 1,000', '0');
                          paperObj.options[1]   = new Option('$100.00 per 1,000', '0');
                          paperObj.options[2]   = new Option('$150.00 per 1,000', '1');
                          paperObj.options[3]   = new Option('$200.00 per 1,000', '1');
                          paperObj.options[4]   = new Option('$250.00 per 1,000', '2');
                          paperObj.options[5]   = new Option('$300.00 per 1,000', '2');
                          paperObj.options[6]   = new Option('$350.00 per 1,000', '3');
                          paperObj.options[7]   = new Option('ZERO', '3');
                          break;

                case 275: paperObj.options[0]   = new Option('$10.00 per 1,000', '0');
                          paperObj.options[1]   = new Option('$15.00 per 1,000', '0');
                          paperObj.options[2]   = new Option('$20.00 per 1,000', '1');
                          paperObj.options[3]   = new Option('$25.00 per 1,000', '1');
                          paperObj.options[4]   = new Option('$30.00 per 1,000', '2');
                          paperObj.options[5]   = new Option('$35.00 per 1,000', '2');
                          paperObj.options[6]   = new Option('$40.00 per 1,000', '3');
                          paperObj.options[7]   = new Option('$45.00 per 1,000', '3');
                          paperObj.options[8]   = new Option('$50.00 per 1,000', '4');
                          paperObj.options[9]   = new Option('$55.00 per 1,000', '4');
                          paperObj.options[10]  = new Option('$60.00 per 1,000', '5');
                          paperObj.options[11]  = new Option('$65.00 per 1,000', '5');
                          paperObj.options[12]  = new Option('$70.00 per 1,000', '6');
                          paperObj.options[13]  = new Option('$75.00 per 1,000', '6');
                          paperObj.options[14]  = new Option('$80.00 per 1,000', '7');
                          paperObj.options[15]  = new Option('$85.00 per 1,000', '7');
                          paperObj.options[16]  = new Option('$90.00 per 1,000', '8');
                          paperObj.options[17]  = new Option('$95.00 per 1,000', '8');
                          paperObj.options[18]  = new Option('$100.00 per 1,000', '9');
                          paperObj.options[19]  = new Option('$110.00 per 1,000', '9');
                          paperObj.options[20]  = new Option('$120.00 per 1,000', '10');
                          paperObj.options[21]  = new Option('$130.00 per 1,000', '10');
                          paperObj.options[22]  = new Option('$140.00 per 1,000', '11');
                          paperObj.options[23]  = new Option('$150.00 per 1,000', '11');
                          paperObj.options[24]  = new Option('$160.00 per 1,000', '12');
                          paperObj.options[25]  = new Option('$170.00 per 1,000', '12');
                          paperObj.options[26]  = new Option('$180.00 per 1,000', '13');
                          paperObj.options[27]  = new Option('$190.00 per 1,000', '13');
                          paperObj.options[28]  = new Option('$200.00 per 1,000', '14');
                          paperObj.options[29]  = new Option('$220.00 per 1,000', '14');
                          paperObj.options[30]  = new Option('$240.00 per 1,000', '15');
                          paperObj.options[31]  = new Option('$260.00 per 1,000', '15');
                          paperObj.options[32]  = new Option('$280.00 per 1,000', '16');
                          paperObj.options[33]  = new Option('$300.00 per 1,000', '16');
                          paperObj.options[34]  = new Option('$320.00 per 1,000', '17');
                          paperObj.options[35]  = new Option('ZERO', '17');
                          break;

                case 293: paperObj.options[0]   = new Option('$10.00 per 1,000', '0');
                          paperObj.options[1]   = new Option('$15.00 per 1,000', '0');
                          paperObj.options[2]   = new Option('$20.00 per 1,000', '1');
                          paperObj.options[3]   = new Option('$25.00 per 1,000', '1');
                          paperObj.options[4]   = new Option('$30.00 per 1,000', '2');
                          paperObj.options[5]   = new Option('$35.00 per 1,000', '2');
                          paperObj.options[6]   = new Option('$40.00 per 1,000', '3');
                          paperObj.options[7]   = new Option('$45.00 per 1,000', '3');
                          paperObj.options[8]   = new Option('$50.00 per 1,000', '4');
                          paperObj.options[9]   = new Option('$55.00 per 1,000', '4');
                          paperObj.options[10]  = new Option('$60.00 per 1,000', '5');
                          paperObj.options[11]  = new Option('$65.00 per 1,000', '5');
                          paperObj.options[12]  = new Option('$70.00 per 1,000', '6');
                          paperObj.options[13]  = new Option('$75.00 per 1,000', '6');
                          paperObj.options[14]  = new Option('$80.00 per 1,000', '7');
                          paperObj.options[15]  = new Option('$85.00 per 1,000', '7');
                          paperObj.options[16]  = new Option('$90.00 per 1,000', '8');
                          paperObj.options[17]  = new Option('$95.00 per 1,000', '8');
                          paperObj.options[18]  = new Option('$100.00 per 1,000', '9');
                          paperObj.options[19]  = new Option('$110.00 per 1,000', '9');
                          paperObj.options[20]  = new Option('$120.00 per 1,000', '10');
                          paperObj.options[21]  = new Option('$130.00 per 1,000', '10');
                          paperObj.options[22]  = new Option('$140.00 per 1,000', '11');
                          paperObj.options[23]  = new Option('$150.00 per 1,000', '11');
                          paperObj.options[24]  = new Option('$160.00 per 1,000', '12');
                          paperObj.options[25]  = new Option('$170.00 per 1,000', '12');
                          paperObj.options[26]  = new Option('$180.00 per 1,000', '13');
                          paperObj.options[27]  = new Option('$190.00 per 1,000', '13');
                          paperObj.options[28]  = new Option('$200.00 per 1,000', '14');
                          paperObj.options[29]  = new Option('$220.00 per 1,000', '14');
                          paperObj.options[30]  = new Option('$240.00 per 1,000', '15');
                          paperObj.options[31]  = new Option('$260.00 per 1,000', '15');
                          paperObj.options[32]  = new Option('$280.00 per 1,000', '16');
                          paperObj.options[33]  = new Option('$300.00 per 1,000', '16');
                          paperObj.options[34]  = new Option('$320.00 per 1,000', '17');
                          paperObj.options[35]  = new Option('ZERO', '17');
                          break;

                case 311: paperObj.options[0]   = new Option('$10.00 per 1,000', '0');
                          paperObj.options[1]   = new Option('$15.00 per 1,000', '0');
                          paperObj.options[2]   = new Option('$20.00 per 1,000', '1');
                          paperObj.options[3]   = new Option('$25.00 per 1,000', '1');
                          paperObj.options[4]   = new Option('$30.00 per 1,000', '2');
                          paperObj.options[5]   = new Option('$35.00 per 1,000', '2');
                          paperObj.options[6]   = new Option('$40.00 per 1,000', '3');
                          paperObj.options[7]   = new Option('$45.00 per 1,000', '3');
                          paperObj.options[8]   = new Option('$50.00 per 1,000', '4');
                          paperObj.options[9]   = new Option('$55.00 per 1,000', '4');
                          paperObj.options[10]  = new Option('$60.00 per 1,000', '5');
                          paperObj.options[11]  = new Option('$65.00 per 1,000', '5');
                          paperObj.options[12]  = new Option('$70.00 per 1,000', '6');
                          paperObj.options[13]  = new Option('$75.00 per 1,000', '6');
                          paperObj.options[14]  = new Option('$80.00 per 1,000', '7');
                          paperObj.options[15]  = new Option('$85.00 per 1,000', '7');
                          paperObj.options[16]  = new Option('$90.00 per 1,000', '8');
                          paperObj.options[17]  = new Option('$95.00 per 1,000', '8');
                          paperObj.options[18]  = new Option('$100.00 per 1,000', '9');
                          paperObj.options[19]  = new Option('$110.00 per 1,000', '9');
                          paperObj.options[20]  = new Option('$120.00 per 1,000', '10');
                          paperObj.options[21]  = new Option('$130.00 per 1,000', '10');
                          paperObj.options[22]  = new Option('$140.00 per 1,000', '11');
                          paperObj.options[23]  = new Option('$150.00 per 1,000', '11');
                          paperObj.options[24]  = new Option('$160.00 per 1,000', '12');
                          paperObj.options[25]  = new Option('$170.00 per 1,000', '12');
                          paperObj.options[26]  = new Option('$180.00 per 1,000', '13');
                          paperObj.options[27]  = new Option('$190.00 per 1,000', '13');
                          paperObj.options[28]  = new Option('$200.00 per 1,000', '14');
                          paperObj.options[29]  = new Option('$220.00 per 1,000', '14');
                          paperObj.options[30]  = new Option('$240.00 per 1,000', '15');
                          paperObj.options[31]  = new Option('$260.00 per 1,000', '15');
                          paperObj.options[32]  = new Option('$280.00 per 1,000', '16');
                          paperObj.options[33]  = new Option('$300.00 per 1,000', '16');
                          paperObj.options[34]  = new Option('$320.00 per 1,000', '17');
                          paperObj.options[35]  = new Option('ZERO', '17');
                          break;

                case 329: paperObj.options[0]  = new Option('Variable', '0'); break;
        }
        paperObj.options[0].selected = "selected";
}

/*
* ===========================================================================
* Crouser Encryption Routine - JavaScript Library
* v1.0 - Written by Edward Crouser
*
* All material is copyright 2012 Rex Edward Crouser II. No material may be
* reproduced without the express written consent of the author.
* ===========================================================================
* A JavaScript implementation of the RSA Data Security, Inc. MD5 Message
* Digest Algorithm, as defined in RFC 1321.
*/

var hexcase = 0;
var b64pad  = "";

function hex_md5(s)             { return rstr2hex(rstr_md5(str2rstr_utf8(s))); }
function b64_md5(s)             { return rstr2b64(rstr_md5(str2rstr_utf8(s))); }
function any_md5(s, e)          { return rstr2any(rstr_md5(str2rstr_utf8(s)), e); }
function hex_hmac_md5(k, d)     { return rstr2hex(rstr_hmac_md5(str2rstr_utf8(k), str2rstr_utf8(d))); }
function b64_hmac_md5(k, d)     { return rstr2b64(rstr_hmac_md5(str2rstr_utf8(k), str2rstr_utf8(d))); }
function any_hmac_md5(k, d, e)  { return rstr2any(rstr_hmac_md5(str2rstr_utf8(k), str2rstr_utf8(d)), e); }
function md5_vm_test()          { return hex_md5("abc").toLowerCase() == "900150983cd24fb0d6963f7d28e17f72"; }
function rstr_md5(s)            { return binl2rstr(binl_md5(rstr2binl(s), s.length * 8)); }

function rstr_hmac_md5(key, data)
{
  var bkey = rstr2binl(key);
  if(bkey.length > 16) bkey = binl_md5(bkey, key.length * 8);

  var ipad = Array(16), opad = Array(16);
  for(var i = 0; i < 16; i++)
  {
    ipad[i] = bkey[i] ^ 0x36363636;
    opad[i] = bkey[i] ^ 0x5C5C5C5C;
  }

  var hash = binl_md5(ipad.concat(rstr2binl(data)), 512 + data.length * 8);
  return binl2rstr(binl_md5(opad.concat(hash), 512 + 128));
}

// =- function: Raw String to Hex --------------------------------------------------=
function rstr2hex(input) {
  try { hexcase } catch(e) { hexcase=0; }
  var hex_tab = hexcase ? "0123456789ABCDEF" : "0123456789abcdef";
  var output = "";
  var x;
  for(var i = 0; i < input.length; i++)
  {
    x = input.charCodeAt(i);
    output += hex_tab.charAt((x >>> 4) & 0x0F)
           +  hex_tab.charAt( x        & 0x0F);
  }
  return output;
}

// =- function: Raw String to Base-64 ----------------------------------------------=
function rstr2b64(input) {
  try { b64pad } catch(e) { b64pad=''; }
  var tab = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
  var output = "";
  var len = input.length;
  for(var i = 0; i < len; i += 3)
  {
    var triplet = (input.charCodeAt(i) << 16)
                | (i + 1 < len ? input.charCodeAt(i+1) << 8 : 0)
                | (i + 2 < len ? input.charCodeAt(i+2)      : 0);
    for(var j = 0; j < 4; j++)
    {
      if(i * 8 + j * 6 > input.length * 8) output += b64pad;
      else output += tab.charAt((triplet >>> 6*(3-j)) & 0x3F);
    }
  }
  return output;
}

// =- function: Raw String to String/Numbers ---------------------------------------=
function rstr2any(input, encoding) {
  var divisor = encoding.length;
  var i, j, q, x, quotient;
  var dividend = Array(Math.ceil(input.length / 2));

  for(i = 0; i < dividend.length; i++) { dividend[i] = (input.charCodeAt(i * 2) << 8) | input.charCodeAt(i * 2 + 1); }

  var full_length = Math.ceil(input.length * 8 / (Math.log(encoding.length) / Math.log(2)));
  var remainders = Array(full_length);

  for(j = 0; j < full_length; j++)
  {
    quotient = Array();
    x = 0;
    for(i = 0; i < dividend.length; i++)
    {
      x = (x << 16) + dividend[i];
      q = Math.floor(x / divisor);
      x -= q * divisor;
      if(quotient.length > 0 || q > 0)
        quotient[quotient.length] = q;
    }
    remainders[j] = x;
    dividend = quotient;
  }

// =- function: Remainder to Output String -----------------------------------------=
  var output = "";
  for(i = remainders.length - 1; i >= 0; i--) output += encoding.charAt(remainders[i]);
  return output;
}

// =- function: Encode to UTF-8 -----------------------------------------=
function str2rstr_utf8(input) {
  var output = "";
  var i = -1;
  var x, y;

  while(++i < input.length)
  {
    /* Decode utf-16 surrogate pairs */
    x = input.charCodeAt(i);
    y = i + 1 < input.length ? input.charCodeAt(i + 1) : 0;
    if(0xD800 <= x && x <= 0xDBFF && 0xDC00 <= y && y <= 0xDFFF) { x = 0x10000 + ((x & 0x03FF) << 10) + (y & 0x03FF); i++; }

    if(x <= 0x7F)
      output += String.fromCharCode(x);
    else if(x <= 0x7FF)
      output += String.fromCharCode(0xC0 | ((x >>> 6 ) & 0x1F),
                                    0x80 | ( x         & 0x3F));
    else if(x <= 0xFFFF)
      output += String.fromCharCode(0xE0 | ((x >>> 12) & 0x0F),
                                    0x80 | ((x >>> 6 ) & 0x3F),
                                    0x80 | ( x         & 0x3F));
    else if(x <= 0x1FFFFF)
      output += String.fromCharCode(0xF0 | ((x >>> 18) & 0x07),
                                    0x80 | ((x >>> 12) & 0x3F),
                                    0x80 | ((x >>> 6 ) & 0x3F),
                                    0x80 | ( x         & 0x3F));
  }
  return output;
}

// =- function: Encode to UTF-16 ----------------------------------------=
function str2rstr_utf16le(input) {
  var output = "";
  for(var i = 0; i < input.length; i++)
    output += String.fromCharCode( input.charCodeAt(i)        & 0xFF,
                                  (input.charCodeAt(i) >>> 8) & 0xFF);
  return output;
}

// =- function: Encode to UTF-16 ----------------------------------------=
function str2rstr_utf16be(input) {
  var output = "";
  for(var i = 0; i < input.length; i++)
    output += String.fromCharCode((input.charCodeAt(i) >>> 8) & 0xFF,
                                   input.charCodeAt(i)        & 0xFF);
  return output;
}

// =- function: Convert Raw to Array ------------------------------------=
function rstr2binl(input) {
  var output = Array(input.length >> 2);
  for(var i = 0; i < output.length; i++)
    output[i] = 0;
  for(var i = 0; i < input.length * 8; i += 8)
    output[i>>5] |= (input.charCodeAt(i / 8) & 0xFF) << (i%32);
  return output;
}

// =- function: Convert Array to Endian ---------------------------------=
function binl2rstr(input) {
  var output = "";
  for(var i = 0; i < input.length * 32; i += 8)
    output += String.fromCharCode((input[i>>5] >>> (i % 32)) & 0xFF);
  return output;
}

// =- function: Calc MD5 ------------------------------------------------=
function binl_md5(x, len) {
  x[len >> 5] |= 0x80 << ((len) % 32);
  x[(((len + 64) >>> 9) << 4) + 14] = len;

  var a =  1732584193;
  var b = -271733879;
  var c = -1732584194;
  var d =  271733878;

  for(var i = 0; i < x.length; i += 16)
  {
    var olda = a;
    var oldb = b;
    var oldc = c;
    var oldd = d;

    a = md5_ff(a, b, c, d, x[i+ 0], 7 , -680876936);
    d = md5_ff(d, a, b, c, x[i+ 1], 12, -389564586);
    c = md5_ff(c, d, a, b, x[i+ 2], 17,  606105819);
    b = md5_ff(b, c, d, a, x[i+ 3], 22, -1044525330);
    a = md5_ff(a, b, c, d, x[i+ 4], 7 , -176418897);
    d = md5_ff(d, a, b, c, x[i+ 5], 12,  1200080426);
    c = md5_ff(c, d, a, b, x[i+ 6], 17, -1473231341);
    b = md5_ff(b, c, d, a, x[i+ 7], 22, -45705983);
    a = md5_ff(a, b, c, d, x[i+ 8], 7 ,  1770035416);
    d = md5_ff(d, a, b, c, x[i+ 9], 12, -1958414417);
    c = md5_ff(c, d, a, b, x[i+10], 17, -42063);
    b = md5_ff(b, c, d, a, x[i+11], 22, -1990404162);
    a = md5_ff(a, b, c, d, x[i+12], 7 ,  1804603682);
    d = md5_ff(d, a, b, c, x[i+13], 12, -40341101);
    c = md5_ff(c, d, a, b, x[i+14], 17, -1502002290);
    b = md5_ff(b, c, d, a, x[i+15], 22,  1236535329);

    a = md5_gg(a, b, c, d, x[i+ 1], 5 , -165796510);
    d = md5_gg(d, a, b, c, x[i+ 6], 9 , -1069501632);
    c = md5_gg(c, d, a, b, x[i+11], 14,  643717713);
    b = md5_gg(b, c, d, a, x[i+ 0], 20, -373897302);
    a = md5_gg(a, b, c, d, x[i+ 5], 5 , -701558691);
    d = md5_gg(d, a, b, c, x[i+10], 9 ,  38016083);
    c = md5_gg(c, d, a, b, x[i+15], 14, -660478335);
    b = md5_gg(b, c, d, a, x[i+ 4], 20, -405537848);
    a = md5_gg(a, b, c, d, x[i+ 9], 5 ,  568446438);
    d = md5_gg(d, a, b, c, x[i+14], 9 , -1019803690);
    c = md5_gg(c, d, a, b, x[i+ 3], 14, -187363961);
    b = md5_gg(b, c, d, a, x[i+ 8], 20,  1163531501);
    a = md5_gg(a, b, c, d, x[i+13], 5 , -1444681467);
    d = md5_gg(d, a, b, c, x[i+ 2], 9 , -51403784);
    c = md5_gg(c, d, a, b, x[i+ 7], 14,  1735328473);
    b = md5_gg(b, c, d, a, x[i+12], 20, -1926607734);

    a = md5_hh(a, b, c, d, x[i+ 5], 4 , -378558);
    d = md5_hh(d, a, b, c, x[i+ 8], 11, -2022574463);
    c = md5_hh(c, d, a, b, x[i+11], 16,  1839030562);
    b = md5_hh(b, c, d, a, x[i+14], 23, -35309556);
    a = md5_hh(a, b, c, d, x[i+ 1], 4 , -1530992060);
    d = md5_hh(d, a, b, c, x[i+ 4], 11,  1272893353);
    c = md5_hh(c, d, a, b, x[i+ 7], 16, -155497632);
    b = md5_hh(b, c, d, a, x[i+10], 23, -1094730640);
    a = md5_hh(a, b, c, d, x[i+13], 4 ,  681279174);
    d = md5_hh(d, a, b, c, x[i+ 0], 11, -358537222);
    c = md5_hh(c, d, a, b, x[i+ 3], 16, -722521979);
    b = md5_hh(b, c, d, a, x[i+ 6], 23,  76029189);
    a = md5_hh(a, b, c, d, x[i+ 9], 4 , -640364487);
    d = md5_hh(d, a, b, c, x[i+12], 11, -421815835);
    c = md5_hh(c, d, a, b, x[i+15], 16,  530742520);
    b = md5_hh(b, c, d, a, x[i+ 2], 23, -995338651);

    a = md5_ii(a, b, c, d, x[i+ 0], 6 , -198630844);
    d = md5_ii(d, a, b, c, x[i+ 7], 10,  1126891415);
    c = md5_ii(c, d, a, b, x[i+14], 15, -1416354905);
    b = md5_ii(b, c, d, a, x[i+ 5], 21, -57434055);
    a = md5_ii(a, b, c, d, x[i+12], 6 ,  1700485571);
    d = md5_ii(d, a, b, c, x[i+ 3], 10, -1894986606);
    c = md5_ii(c, d, a, b, x[i+10], 15, -1051523);
    b = md5_ii(b, c, d, a, x[i+ 1], 21, -2054922799);
    a = md5_ii(a, b, c, d, x[i+ 8], 6 ,  1873313359);
    d = md5_ii(d, a, b, c, x[i+15], 10, -30611744);
    c = md5_ii(c, d, a, b, x[i+ 6], 15, -1560198380);
    b = md5_ii(b, c, d, a, x[i+13], 21,  1309151649);
    a = md5_ii(a, b, c, d, x[i+ 4], 6 , -145523070);
    d = md5_ii(d, a, b, c, x[i+11], 10, -1120210379);
    c = md5_ii(c, d, a, b, x[i+ 2], 15,  718787259);
    b = md5_ii(b, c, d, a, x[i+ 9], 21, -343485551);

    a = safe_add(a, olda);
    b = safe_add(b, oldb);
    c = safe_add(c, oldc);
    d = safe_add(d, oldd);
  }
  return Array(a, b, c, d);
}

// =- function: Algorithm -----------------------------------------------=
function md5_cmn(q, a, b, x, s, t)      { return safe_add(bit_rol(safe_add(safe_add(a, q), safe_add(x, t)), s),b); }
function md5_ff(a, b, c, d, x, s, t)    { return md5_cmn((b & c) | ((~b) & d), a, b, x, s, t); }
function md5_gg(a, b, c, d, x, s, t)    { return md5_cmn((b & d) | (c & (~d)), a, b, x, s, t); }
function md5_hh(a, b, c, d, x, s, t)    { return md5_cmn(b ^ c ^ d, a, b, x, s, t); }
function md5_ii(a, b, c, d, x, s, t)    { return md5_cmn(c ^ (b | (~d)), a, b, x, s, t); }

// =- function: Add Integers --------------------------------------------=
function safe_add(x, y) {
  var lsw = (x & 0xFFFF) + (y & 0xFFFF);
  var msw = (x >> 16) + (y >> 16) + (lsw >> 16);
  return (msw << 16) | (lsw & 0xFFFF);
}

// =- function: Rotate 32-bit numbers -----------------------------------=
function bit_rol(num, cnt) { return (num << cnt) | (num >>> (32 - cnt)); }

/*
* ===========================================================================
* Crouser Encryption Routine - JavaScript Library
* v1.0 - Written by Edward Crouser
*
* All material is copyright 2012 Rex Edward Crouser II. No material may be
* reproduced without the express written consent of the author.
* ===========================================================================
* A JavaScript implementation of the RSA Data Security, Inc. MD5 Message
* Digest Algorithm, as defined in RFC 1321.
*/

// =- function: Main Decode ---------------------------------------------=
function sfxdm45acp() {
//      alert("function sfxdm45acp()");
        var currentDate = new Date();
        var expiration  = new Date();
        var lastyear    = new Date();

        if (platform == 'mac') { chkCookies(); }  // Check cookies before doing anything else on the Mac.

        if (platform == 'pc') {
                var regKey  = window.external.GetGlobalVariable("pc-registrationKey","");
                var regYear = regKey.substr(6,4);
        }
        if (platform == 'mac') {
                if(guide == 'offset' ) { var regKey = getCookieValue("offset-registrationKey");  }
                if(guide == 'digital') { var regKey = getCookieValue("digital-registrationKey"); }
                var regYear = regKey.substr(6,4);
        }

        // ---------------------------------------------------------------------------------------------
        // @REC - Note - regYear = estguideyear; setFullYear = estguideyear-1;
        // ---------------------------------------------------------------------------------------------
        if (regYear == null) { regYear = 2026; } else { regYear = parseInt(regYear) + 1; }
        expiration.setFullYear(regYear,1,15);
        lastyear.setFullYear(2024,0,1);

        if (currentDate > lastyear && currentDate < expiration) {
                        if (platform == 'pc') {
                                var userName        = window.external.GetGlobalVariable("pc-userName","");
                                var companyName     = window.external.GetGlobalVariable("pc-companyName","");
                                var registrationKey = window.external.GetGlobalVariable("pc-registrationKey","");
                                checkKey(userName, companyName, registrationKey,1);
                                }
                        if (platform == 'mac') {
                                chkCookies();
                                if(guide == 'offset' ) { var userName        = getCookieValue("offset-userName");         }
                                if(guide == 'digital') { var userName        = getCookieValue("digital-userName");        }
                                if(guide == 'offset' ) { var companyName     = getCookieValue("offset-companyName");      }
                                if(guide == 'digital') { var companyName     = getCookieValue("digital-companyName");     }
                                if(guide == 'offset' ) { var registrationKey = getCookieValue("offset-registrationKey");  }
                                if(guide == 'digital') { var registrationKey = getCookieValue("digital-registrationKey"); }
                                checkKey(userName, companyName, registrationKey,1);
                                }
//        }else { top.document.location.href = "error.html"; }
      }else { top.document.location.href = "expired.html"; }

}

// =- function: Check Cookies -------------------------------------------=
function chkCookies()  {
//                      alert("function chkCookies()");
                        if(platform == 'pc') {
                                 if (window.external.GetGlobalVariable("pc-userName","") == "")               { top.document.location.href = 'regkey.html'; }
                                 if (window.external.GetGlobalVariable("pc-companyName","") == "")            { top.document.location.href = 'regkey.html'; }
                                 if (window.external.GetGlobalVariable("pc-registrationKey","") == "")        { top.document.location.href = 'regkey.html'; }
                                 if (window.external.GetGlobalVariable("pc-defaultPrice","") == "")           { top.document.location.href = 'regkey.html'; }
                                 if (window.external.GetGlobalVariable("pc-defaultCategory","") == "")        { top.document.location.href = 'regkey.html'; }
                                 }
                        if(guide == 'offset' && platform == 'mac') {
                                 if (!getCookieValue("offset-userName"))               { top.document.location.href = 'regkey.html'; }
                                 if (!getCookieValue("offset-companyName"))            { top.document.location.href = 'regkey.html'; }
                                 if (!getCookieValue("offset-registrationKey"))        { top.document.location.href = 'regkey.html'; }
                                 if (!getCookieValue("offset-defaultPrice"))           { top.document.location.href = 'regkey.html'; }
                                 if (!getCookieValue("offset-defaultCategory"))        { top.document.location.href = 'regkey.html'; }
                                 }
                        if(guide == 'digital' && platform == 'mac') {
                                 if (!getCookieValue("digital-userName"))              { top.document.location.href = 'regkey.html'; }
                                 if (!getCookieValue("digital-companyName"))           { top.document.location.href = 'regkey.html'; }
                                 if (!getCookieValue("digital-registrationKey"))       { top.document.location.href = 'regkey.html'; }
                                 if (!getCookieValue("digital-defaultPrice"))          { top.document.location.href = 'regkey.html'; }
                                 if (!getCookieValue("digital-defaultCategory"))       { top.document.location.href = 'regkey.html'; }
                                 }
}

// =- function: Store Data ----------------------------------------------=
function storeData(form) {
                        if(platform == 'pc') {
                                 window.external.SetGlobalVariable('pc-userName', alltrim(form.userName.value), true);
                                 window.external.SetGlobalVariable('pc-companyName', alltrim(form.companyName.value), true);
                                 window.external.SetGlobalVariable('pc-registrationKey', keyParser(form.registrationKey.value), true);
                                 window.external.SetGlobalVariable('pc-defaultPrice', form.defaultPrice.value, true);
                                 window.external.SetGlobalVariable('pc-defaultCategory', form.defaultCategory.value, true);
                                 userName        = window.external.GetGlobalVariable('pc-userName','');
                                 companyName     = window.external.GetGlobalVariable('pc-companyName','');
                                 registrationKey = window.external.GetGlobalVariable('pc-registrationKey','');
                                 defaultPrice    = window.external.GetGlobalVariable('pc-defaultPrice','');
                                 defaultCategory = window.external.GetGlobalVariable('pc-defaultCategory','');
                                 top.document.location.href = 'check.html';
                                 return true;
                                }
                        if(guide == 'offset' && platform == 'mac') {
                                 writePersistentCookie('offset-userName', alltrim(form.userName.value), "years", 1);
                                 writePersistentCookie('offset-companyName', alltrim(form.companyName.value), "years", 1);
                                 writePersistentCookie('offset-registrationKey', keyParser(form.registrationKey.value), "years", 1);
                                 writePersistentCookie('offset-defaultPrice', form.defaultPrice.value, "years", 1);
                                 writePersistentCookie('offset-defaultCategory', form.defaultCategory.value, "years", 1);
                                }
                        if(guide == 'digital' && platform == 'mac') {
                                 writePersistentCookie('digital-userName', alltrim(form.userName.value), "years", 1);
                                 writePersistentCookie('digital-companyName', alltrim(form.companyName.value), "years", 1);
                                 writePersistentCookie('digital-registrationKey', keyParser(form.registrationKey.value), "years", 1);
                                 writePersistentCookie('digital-defaultPrice', form.defaultPrice.value, "years", 1);
                                 writePersistentCookie('digital-defaultCategory', form.defaultCategory.value, "years", 1);
                                }
                       return true;
}

// =- function: regKeyStartUp -------------------------------------------=
function regKeyStartUp() {
//                      alert("function regKeyStartUp()");
                        if(platform == 'pc') {
                              document.regForm.userName.value         = window.external.GetGlobalVariable("pc-userName","");
                              document.regForm.companyName.value      = window.external.GetGlobalVariable("pc-companyName","");
                              document.regForm.registrationKey.value  = window.external.GetGlobalVariable("pc-registrationKey","");
                              document.regForm.defaultPrice.value     = window.external.GetGlobalVariable("pc-defaultPrice","2");
                              document.regForm.defaultCategory.value  = window.external.GetGlobalVariable("pc-defaultCategory","1");
                        }
                        if(guide == 'offset' && platform == 'mac') {
                              userName        = getCookieValue("offset-userName");
                              companyName     = getCookieValue("offset-companyName");
                              registrationKey = getCookieValue("offset-registrationKey");
                              defaultPrice    = getCookieValue("offset-defaultPrice");
                              defaultCategory = getCookieValue("offset-defaultCategory");

                              document.regForm.userName.value         = getCookieValue("offset-userName");
                              document.regForm.companyName.value      = getCookieValue("offset-companyName");
                              document.regForm.registrationKey.value  = getCookieValue("offset-registrationKey");
                              document.regForm.defaultPrice.value     = getCookieValue("offset-defaultPrice");
                              document.regForm.defaultCategory.value  = getCookieValue("offset-defaultCategory");
                        }
                        if(guide == 'digital' && platform == 'mac') {
                              userName        = getCookieValue("digital-userName");
                              companyName     = getCookieValue("digital-companyName");
                              registrationKey = getCookieValue("digital-registrationKey");
                              defaultPrice    = getCookieValue("digital-defaultPrice");
                              defaultCategory = getCookieValue("digital-defaultCategory");

                              document.regForm.userName.value         = getCookieValue("digital-userName");
                              document.regForm.companyName.value      = getCookieValue("digital-companyName");
                              document.regForm.registrationKey.value  = getCookieValue("digital-registrationKey");
                              document.regForm.defaultPrice.value     = getCookieValue("digital-defaultPrice");
                              document.regForm.defaultCategory.value  = getCookieValue("digital-defaultCategory");
                        }
}

// =- function: checkKey ------------------------------------------------=
function checkKey (regName, regCompany, regKey, forwardPage) {
//                            alert("function checkKey()");

                              regName    = strtoupper(alltrim(regName));
                              regCompany = strtoupper(alltrim(regCompany));

// ---------------------------------------------------------------------------------------------
// @REC - Yearly key changes - obfuscate variable order - change to math formula in future
// ---------------------------------------------------------------------------------------------
                              if(guide == 'offset')  { var swie = "20265";  }
                              if(guide == 'offset')  { var doiw = "MX5n0";  }
                              if(guide == 'offset')  { var jdsy = "coqXZ";  }
                              if(guide == 'offset')  { var jwus = "eGPZk";  }
                              if(guide == 'offset')  { var wuen = "XFOJe";  }
                              if(guide == 'offset')  { var xkfc = "E90K3";  }
                              if(guide == 'offset')  { var kjse = "u1Vin";  }
                              if(guide == 'offset')  { var iewi = "ylRol";  }
                              if(guide == 'offset')  { var jude = "eXvTom"; }

                              if(guide == 'digital') { var swie = "20265";  }
                              if(guide == 'digital') { var doiw = "ZMX5n";  }
                              if(guide == 'digital') { var jdsy = "0coRZ";  }
                              if(guide == 'digital') { var jwus = "1x2Zk";  }
                              if(guide == 'digital') { var wuen = "XOJga";  }
                              if(guide == 'digital') { var xkfc = "sjDXp";  }
                              if(guide == 'digital') { var kjse = "ZrVin";  }
                              if(guide == 'digital') { var iewi = "ylRol";  }
                              if(guide == 'digital') { var jude = "eX9Tom"; }

                              var kqps       = "WARE";
                              var kwox       = "GDG";
                              var kaid       = "SOFT";
                              var ejsa       = swie + doiw;
                              var kjwd       = jdsy + jwus;
                              var dja0       = wuen + xkfc;
                              var dyte       = kjse + iewi;
                              var dejw       = jude;
                              var pubID      = ejsa+kjwd+dja0+dyte+dejw;

                              var SA = strtoupper(hex_md5(regName.concat(regCompany,pubID)));
                              var SB = strtoupper(hex_md5(pubID));
                              var SD = strtoupper(hex_md5(pubID + regName));

                              var S1 = SA.substr(1,3) + SA.substr(0,2);
                              var S2 = strtoupper(pubID.substr(0,4)) + SB.substr(5,1);
                              var S3 = SD.substr(2,5);
                              var S4 = hex_md5(S1+S2+S3+pubID+kwox+kaid+kqps);
                              var S4 = strtoupper(S4.substr(1,5));
                              var SF = S1+"-"+S2+"-"+S3+"-"+S4;

                              var keyBank1 = regKey.substr(0,5);
                              var keyBank2 = regKey.substr(6,5);
                              var keyBank3 = regKey.substr(12,5);
                              var keyBank4 = regKey.substr(18,5);

// ---------------------------------------------------------------------------------------------
// @REC - Yearly EXTENSION key change - obfuscate variable order
// ---------------------------------------------------------------------------------------------

                              if (SF != regKey ) {
                                      if(guide == 'offset')  { var swie = "2027h";  }   // Extended
                                      if(guide == 'offset')  { var doiw = "EMX5n";  }   // Extended
                                      if(guide == 'offset')  { var jdsy = "0coXJ";  }   // Extended
                                      if(guide == 'offset')  { var jwus = "fGPZc";  }   // Extended
                                      if(guide == 'offset')  { var wuen = "jOJga";  }   // Extended
                                      if(guide == 'offset')  { var xkfc = "s9383";  }   // Extended
                                      if(guide == 'offset')  { var kjse = "u2Vin";  }   // Extended
                                      if(guide == 'offset')  { var iewi = "ylRol";  }   // Extended
                                      if(guide == 'offset')  { var jude = "eX0Tom"; }   // Extended

                                      if(guide == 'digital') { var swie = "2027V";  }   // Extended
                                      if(guide == 'digital') { var doiw = "KMX5n";  }   // Extended
                                      if(guide == 'digital') { var jdsy = "c0qR4";  }   // Extended
                                      if(guide == 'digital') { var jwus = "11500";  }   // Extended
                                      if(guide == 'digital') { var wuen = "cOJdW";  }   // Extended
                                      if(guide == 'digital') { var xkfc = "djD8d";  }   // Extended
                                      if(guide == 'digital') { var kjse = "ZrVin";  }   // Extended
                                      if(guide == 'digital') { var iewi = "ylRol";  }   // Extended
                                      if(guide == 'digital') { var jude = "eX9Tom"; }   // Extended

                                      var ejsa       = swie + doiw;
                                      var kjwd       = jdsy + jwus;
                                      var dja0       = wuen + xkfc;
                                      var dyte       = kjse + iewi;
                                      var dejw       = jude;
                                      var pubID      = ejsa+kjwd+dja0+dyte+dejw;

                                      var SA = strtoupper(hex_md5(regName.concat(regCompany,pubID)));
                                      var SB = strtoupper(hex_md5(pubID));
                                      var SD = strtoupper(hex_md5(pubID + regName));

                                      var S1 = SA.substr(1,3) + SA.substr(0,2);
                                      var S2 = strtoupper(pubID.substr(0,4)) + SB.substr(5,1);
                                      var S3 = SD.substr(2,5);
                                      var S4 = hex_md5(S1+S2+S3+pubID+kwox+kaid+kqps);
                                      var S4 = strtoupper(S4.substr(1,5));
                                      var SF = S1+"-"+S2+"-"+S3+"-"+S4;

                                      var keyBank1 = regKey.substr(0,5);
                                      var keyBank2 = regKey.substr(6,5);
                                      var keyBank3 = regKey.substr(12,5);
                                      var keyBank4 = regKey.substr(18,5);

                                      if (SF != regKey ) { parent.top.document.location.href = 'error.html'; return false; }
                              }

                              if (forwardPage = 1) {
                                      if (platform == 'mac') { top.document.location.href = 'index-mac.html'; return false; }
                                      if (platform == 'pc')  { top.document.location.href = 'index-pc.html'; return false; }
                                      }
}

// =- function: Supplemental Check --------------------------------------=
function colt186045a() {
                        if(platform == 'mac') {
                                chkCookies();
                                if(guide == 'offset' ) { var userName        = getCookieValue("offset-userName");          }
                                if(guide == 'digital') { var userName        = getCookieValue("digital-userName");         }
                                if(guide == 'offset' ) { var companyName     = getCookieValue("offset-companyName");       }
                                if(guide == 'digital') { var companyName     = getCookieValue("digital-companyName");      }
                                if(guide == 'offset' ) { var registrationKey = getCookieValue("offset-registrationKey");   }
                                if(guide == 'digital') { var registrationKey = getCookieValue("digital-registrationKey");  }
                                suppKey(userName, companyName, registrationKey,0);
                        }
                        if(platform == 'pc') {
                                var userName        = window.external.GetGlobalVariable("pc-userName","");
                                var companyName     = window.external.GetGlobalVariable("pc-companyName","");
                                var registrationKey = window.external.GetGlobalVariable("pc-registrationKey","");
                                suppKey(userName, companyName, registrationKey,0);
                                return false;
//                        }
}

// =- function: checkKey ------------------------------------------------=
function suppKey (regName, regCompany, regKey, forwardPage) {
//                            alert("function checkKey()");

                              regName    = strtoupper(alltrim(regName));
                              regCompany = strtoupper(alltrim(regCompany));

// ---------------------------------------------------------------------------------------------
// @REC - Yearly key change - Supplemental! - Obfuscate variable order (copy from above)
// ---------------------------------------------------------------------------------------------
                              if(guide == 'offset')  { var swie = "20265";  }
                              if(guide == 'offset')  { var doiw = "MX5n0";  }
                              if(guide == 'offset')  { var jdsy = "coqXZ";  }
                              if(guide == 'offset')  { var jwus = "eGPZk";  }
                              if(guide == 'offset')  { var wuen = "XFOJe";  }
                              if(guide == 'offset')  { var xkfc = "E90K3";  }
                              if(guide == 'offset')  { var kjse = "u1Vin";  }
                              if(guide == 'offset')  { var iewi = "ylRol";  }
                              if(guide == 'offset')  { var jude = "eXvTom"; }

                              if(guide == 'digital') { var swie = "20265";  }
                              if(guide == 'digital') { var doiw = "ZMX5n";  }
                              if(guide == 'digital') { var jdsy = "0coRZ";  }
                              if(guide == 'digital') { var jwus = "1x2Zk";  }
                              if(guide == 'digital') { var wuen = "XOJga";  }
                              if(guide == 'digital') { var xkfc = "sjDXp";  }
                              if(guide == 'digital') { var kjse = "ZrVin";  }
                              if(guide == 'digital') { var iewi = "ylRol";  }
                              if(guide == 'digital') { var jude = "eX9Tom"; }

                              var kqps       = "WARE";
                              var kwox       = "GDG";
                              var kaid       = "SOFT";
                              var ejsa       = swie + doiw;
                              var kjwd       = jdsy + jwus;
                              var dja0       = wuen + xkfc;
                              var dyte       = kjse + iewi;
                              var dejw       = jude;
                              var pubID      = ejsa+kjwd+dja0+dyte+dejw;

                              var SA = strtoupper(hex_md5(regName.concat(regCompany,pubID)));
                              var SB = strtoupper(hex_md5(pubID));
                              var SD = strtoupper(hex_md5(pubID + regName));

                              var S1 = SA.substr(1,3) + SA.substr(0,2);
                              var S2 = strtoupper(pubID.substr(0,4)) + SB.substr(5,1);
                              var S3 = SD.substr(2,5);
                              var S4 = hex_md5(S1+S2+S3+pubID+kwox+kaid+kqps);
                              var S4 = strtoupper(S4.substr(1,5));
                              var SF = S1+"-"+S2+"-"+S3+"-"+S4;

                              var keyBank1 = regKey.substr(0,5);
                              var keyBank2 = regKey.substr(6,5);
                              var keyBank3 = regKey.substr(12,5);
                              var keyBank4 = regKey.substr(18,5);

// ---------------------------------------------------------------------------------------------
// @REC - Yearly EXTENSION key change - Supplemental! - Obfuscate variable order (copy from above)
// ---------------------------------------------------------------------------------------------

                              if (SF != regKey ) {
                                      if(guide == 'offset')  { var swie = "2027h";  }   // Extended
                                      if(guide == 'offset')  { var doiw = "EMX5n";  }   // Extended
                                      if(guide == 'offset')  { var jdsy = "0coXJ";  }   // Extended
                                      if(guide == 'offset')  { var jwus = "fGPZc";  }   // Extended
                                      if(guide == 'offset')  { var wuen = "jOJga";  }   // Extended
                                      if(guide == 'offset')  { var xkfc = "s9383";  }   // Extended
                                      if(guide == 'offset')  { var kjse = "u2Vin";  }   // Extended
                                      if(guide == 'offset')  { var iewi = "ylRol";  }   // Extended
                                      if(guide == 'offset')  { var jude = "eX0Tom"; }   // Extended

                                      if(guide == 'digital') { var swie = "2027V";  }   // Extended
                                      if(guide == 'digital') { var doiw = "KMX5n";  }   // Extended
                                      if(guide == 'digital') { var jdsy = "c0qR4";  }   // Extended
                                      if(guide == 'digital') { var jwus = "11500";  }   // Extended
                                      if(guide == 'digital') { var wuen = "cOJdW";  }   // Extended
                                      if(guide == 'digital') { var xkfc = "djD8d";  }   // Extended
                                      if(guide == 'digital') { var kjse = "ZrVin";  }   // Extended
                                      if(guide == 'digital') { var iewi = "ylRol";  }   // Extended
                                      if(guide == 'digital') { var jude = "eX9Tom"; }   // Extended

                                      var ejsa       = swie + doiw;
                                      var kjwd       = jdsy + jwus;
                                      var dja0       = wuen + xkfc;
                                      var dyte       = kjse + iewi;
                                      var dejw       = jude;
                                      var pubID      = ejsa+kjwd+dja0+dyte+dejw;

                                      var SA = strtoupper(hex_md5(regName.concat(regCompany,pubID)));
                                      var SB = strtoupper(hex_md5(pubID));
                                      var SD = strtoupper(hex_md5(pubID + regName));

                                      var S1 = SA.substr(1,3) + SA.substr(0,2);
                                      var S2 = strtoupper(pubID.substr(0,4)) + SB.substr(5,1);
                                      var S3 = SD.substr(2,5);
                                      var S4 = hex_md5(S1+S2+S3+pubID+kwox+kaid+kqps);
                                      var S4 = strtoupper(S4.substr(1,5));
                                      var SF = S1+"-"+S2+"-"+S3+"-"+S4;

                                      var keyBank1 = regKey.substr(0,5);
                                      var keyBank2 = regKey.substr(6,5);
                                      var keyBank3 = regKey.substr(12,5);
                                      var keyBank4 = regKey.substr(18,5);

                                      if (SF != regKey ) { parent.top.document.location.href = 'error.html'; return false; }
                              }



}
}


// Create a JSON object only if one does not already exist. We create the
// methods in a closure to avoid creating global variables.

var JSON;
if (!JSON) {
    JSON = {};
}

(function () {
    'use strict';

    function f(n) {
        // Format integers to have at least two digits.
        return n < 10 ? '0' + n : n;
    }

    if (typeof Date.prototype.toJSON !== 'function') {

        Date.prototype.toJSON = function (key) {

            return isFinite(this.valueOf())
                ? this.getUTCFullYear()     + '-' +
                    f(this.getUTCMonth() + 1) + '-' +
                    f(this.getUTCDate())      + 'T' +
                    f(this.getUTCHours())     + ':' +
                    f(this.getUTCMinutes())   + ':' +
                    f(this.getUTCSeconds())   + 'Z'
                : null;
        };

        String.prototype.toJSON      =
            Number.prototype.toJSON  =
            Boolean.prototype.toJSON = function (key) {
                return this.valueOf();
            };
    }

    var cx = /[\u0000\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,
        escapable = /[\\\"\x00-\x1f\x7f-\x9f\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,
        gap,
        indent,
        meta = {    // table of character substitutions
            '\b': '\\b',
            '\t': '\\t',
            '\n': '\\n',
            '\f': '\\f',
            '\r': '\\r',
            '"' : '\\"',
            '\\': '\\\\'
        },
        rep;


    function quote(string) {

// If the string contains no control characters, no quote characters, and no
// backslash characters, then we can safely slap some quotes around it.
// Otherwise we must also replace the offending characters with safe escape
// sequences.

        escapable.lastIndex = 0;
        return escapable.test(string) ? '"' + string.replace(escapable, function (a) {
            var c = meta[a];
            return typeof c === 'string'
                ? c
                : '\\u' + ('0000' + a.charCodeAt(0).toString(16)).slice(-4);
        }) + '"' : '"' + string + '"';
    }


    function str(key, holder) {

// Produce a string from holder[key].

        var i,          // The loop counter.
            k,          // The member key.
            v,          // The member value.
            length,
            mind = gap,
            partial,
            value = holder[key];

// If the value has a toJSON method, call it to obtain a replacement value.

        if (value && typeof value === 'object' &&
                typeof value.toJSON === 'function') {
            value = value.toJSON(key);
        }

// If we were called with a replacer function, then call the replacer to
// obtain a replacement value.

        if (typeof rep === 'function') {
            value = rep.call(holder, key, value);
        }

// What happens next depends on the value's type.

        switch (typeof value) {
        case 'string':
            return quote(value);

        case 'number':

// JSON numbers must be finite. Encode non-finite numbers as null.

            return isFinite(value) ? String(value) : 'null';

        case 'boolean':
        case 'null':

// If the value is a boolean or null, convert it to a string. Note:
// typeof null does not produce 'null'. The case is included here in
// the remote chance that this gets fixed someday.

            return String(value);

// If the type is 'object', we might be dealing with an object or an array or
// null.

        case 'object':

// Due to a specification blunder in ECMAScript, typeof null is 'object',
// so watch out for that case.

            if (!value) {
                return 'null';
            }

// Make an array to hold the partial results of stringifying this object value.

            gap += indent;
            partial = [];

// Is the value an array?

            if (Object.prototype.toString.apply(value) === '[object Array]') {

// The value is an array. Stringify every element. Use null as a placeholder
// for non-JSON values.

                length = value.length;
                for (i = 0; i < length; i += 1) {
                    partial[i] = str(i, value) || 'null';
                }

// Join all of the elements together, separated with commas, and wrap them in
// brackets.

                v = partial.length === 0
                    ? '[]'
                    : gap
                    ? '[\n' + gap + partial.join(',\n' + gap) + '\n' + mind + ']'
                    : '[' + partial.join(',') + ']';
                gap = mind;
                return v;
            }

// If the replacer is an array, use it to select the members to be stringified.

            if (rep && typeof rep === 'object') {
                length = rep.length;
                for (i = 0; i < length; i += 1) {
                    if (typeof rep[i] === 'string') {
                        k = rep[i];
                        v = str(k, value);
                        if (v) {
                            partial.push(quote(k) + (gap ? ': ' : ':') + v);
                        }
                    }
                }
            } else {

// Otherwise, iterate through all of the keys in the object.

                for (k in value) {
                    if (Object.prototype.hasOwnProperty.call(value, k)) {
                        v = str(k, value);
                        if (v) {
                            partial.push(quote(k) + (gap ? ': ' : ':') + v);
                        }
                    }
                }
            }

// Join all of the member texts together, separated with commas,
// and wrap them in braces.

            v = partial.length === 0
                ? '{}'
                : gap
                ? '{\n' + gap + partial.join(',\n' + gap) + '\n' + mind + '}'
                : '{' + partial.join(',') + '}';
            gap = mind;
            return v;
        }
    }

// If the JSON object does not yet have a stringify method, give it one.

    if (typeof JSON.stringify !== 'function') {
        JSON.stringify = function (value, replacer, space) {

// The stringify method takes a value and an optional replacer, and an optional
// space parameter, and returns a JSON text. The replacer can be a function
// that can replace values, or an array of strings that will select the keys.
// A default replacer method can be provided. Use of the space parameter can
// produce text that is more easily readable.

            var i;
            gap = '';
            indent = '';

// If the space parameter is a number, make an indent string containing that
// many spaces.

            if (typeof space === 'number') {
                for (i = 0; i < space; i += 1) {
                    indent += ' ';
                }

// If the space parameter is a string, it will be used as the indent string.

            } else if (typeof space === 'string') {
                indent = space;
            }

// If there is a replacer, it must be a function or an array.
// Otherwise, throw an error.

            rep = replacer;
            if (replacer && typeof replacer !== 'function' &&
                    (typeof replacer !== 'object' ||
                    typeof replacer.length !== 'number')) {
                throw new Error('JSON.stringify');
            }

// Make a fake root object containing our value under the key of ''.
// Return the result of stringifying the value.

            return str('', {'': value});
        };
    }


// If the JSON object does not yet have a parse method, give it one.

    if (typeof JSON.parse !== 'function') {
        JSON.parse = function (text, reviver) {

// The parse method takes a text and an optional reviver function, and returns
// a JavaScript value if the text is a valid JSON text.

            var j;

            function walk(holder, key) {

// The walk method is used to recursively walk the resulting structure so
// that modifications can be made.

                var k, v, value = holder[key];
                if (value && typeof value === 'object') {
                    for (k in value) {
                        if (Object.prototype.hasOwnProperty.call(value, k)) {
                            v = walk(value, k);
                            if (v !== undefined) {
                                value[k] = v;
                            } else {
                                delete value[k];
                            }
                        }
                    }
                }
                return reviver.call(holder, key, value);
            }


// Parsing happens in four stages. In the first stage, we replace certain
// Unicode characters with escape sequences. JavaScript handles many characters
// incorrectly, either silently deleting them, or treating them as line endings.

            text = String(text);
            cx.lastIndex = 0;
            if (cx.test(text)) {
                text = text.replace(cx, function (a) {
                    return '\\u' +
                        ('0000' + a.charCodeAt(0).toString(16)).slice(-4);
                });
            }

// In the second stage, we run the text against regular expressions that look
// for non-JSON patterns. We are especially concerned with '()' and 'new'
// because they can cause invocation, and '=' because it can cause mutation.
// But just to be safe, we want to reject all unexpected forms.

// We split the second stage into 4 regexp operations in order to work around
// crippling inefficiencies in IE's and Safari's regexp engines. First we
// replace the JSON backslash pairs with '@' (a non-JSON character). Second, we
// replace all simple value tokens with ']' characters. Third, we delete all
// open brackets that follow a colon or comma or that begin the text. Finally,
// we look to see that the remaining characters are only whitespace or ']' or
// ',' or ':' or '{' or '}'. If that is so, then the text is safe for eval.

            if (/^[\],:{}\s]*$/
                    .test(text.replace(/\\(?:["\\\/bfnrt]|u[0-9a-fA-F]{4})/g, '@')
                        .replace(/"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?/g, ']')
                        .replace(/(?:^|:|,)(?:\s*\[)+/g, ''))) {

// In the third stage we use the eval function to compile the text into a
// JavaScript structure. The '{' operator is subject to a syntactic ambiguity
// in JavaScript: it can begin a block or an object literal. We wrap the text
// in parens to eliminate the ambiguity.

                j = eval('(' + text + ')');

// In the optional fourth stage, we recursively walk the new structure, passing
// each name/value pair to a reviver function for possible transformation.

                return typeof reviver === 'function'
                    ? walk({'': j}, '')
                    : j;
            }

// If the text is not JSON parseable, then a SyntaxError is thrown.

            throw new SyntaxError('JSON.parse');
        };
    }
}());
